/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.datagen;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.datagen.DataGenParams;

public abstract class AbstractGenerator {
    private static final Log logger = LogFactory.getLog(AbstractGenerator.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String ORGANIZATION_CLASS_URI = "http://purl.obolibrary.org/obo/OBI_0000245";
    public static final String CORE_FACILITY_CLASS_URI = "http://purl.obolibrary.org/obo/ERO_0000002";
    protected final EIOntModel eagleiOntModel;
    private static Map<String, List<OntClass>> typeToSubclasses = new HashMap<String, List<OntClass>>();

    public AbstractGenerator(EIOntModel eagleiOntModel) throws IOException {
        this.eagleiOntModel = eagleiOntModel;
    }

    public void generate(DataGenParams params) throws IOException {
        if (DEBUG) {
            logger.debug((Object)"Starting generation...");
        }
        int total = 0;
        for (String uri : params.getInstitutionURIs()) {
            String label = params.getInstitutionName(uri);
            int numGenerated = this.generateForInstitution(uri, label, params);
            total += numGenerated;
            logger.info((Object)("Generated " + numGenerated + " resources for " + label));
            if (!DEBUG) continue;
            logger.debug((Object)("Generated " + numGenerated + " resources for " + label));
        }
        if (DEBUG) {
            logger.debug((Object)("Generated " + total + " resources."));
        }
        this.closeStorage();
        if (DEBUG) {
            logger.debug((Object)"...generation finished.");
        }
    }

    public abstract void closeStorage() throws IOException;

    public int generateForInstitution(String uri, String label, DataGenParams genParams) throws IOException {
        int total = 0;
        int numCores = genParams.getNumCoreFacilities();
        if (DEBUG) {
            logger.debug((Object)("Generating " + numCores + " core facilities for " + label + ": " + uri));
        }
        for (int i = 1; i <= numCores; ++i) {
            total += this.generateLab(uri, label, AbstractGenerator.getCoreFacilityName(label, i, genParams), AbstractGenerator.getCoreFacilityURI(uri, i, genParams), null, CORE_FACILITY_CLASS_URI, genParams);
        }
        return total;
    }

    public int generateLab(String institutionURI, String institutionLabel, String labLabel, String labURI, String labURL, String labTypeURI, DataGenParams genParams) throws IOException {
        int totalCount = 0;
        List topLevelClasses = this.eagleiOntModel.getTopLevelClasses();
        for (EIClass topLevelClass : topLevelClasses) {
            List<OntClass> subclasses;
            int numSubclasses;
            if (topLevelClass.getEntity().getURI().toString().equals(ORGANIZATION_CLASS_URI) || (numSubclasses = (subclasses = this.getSubClasses(topLevelClass.getEntity().getURI().toString())).size()) == 0) continue;
            int numberResources = genParams.getNumResourcesPerClass();
            numberResources = Math.min(numberResources, 25);
            for (int i = 1; i <= numberResources; ++i) {
                OntClass randomSub = subclasses.get(DataGenParams.getRandom(0, numSubclasses));
                if (randomSub.getURI() == null || randomSub.getURI().equals(OWL.Nothing.getURI())) continue;
                String resourceLabel = AbstractGenerator.getResourceName(i, randomSub);
                String resourceURI = AbstractGenerator.getResourceURI(++totalCount, labURI);
                this.generateResource(institutionURI, institutionLabel, resourceLabel, resourceURI, randomSub.getURI(), null, labLabel, labURI, genParams);
            }
        }
        return totalCount;
    }

    public abstract void generateResource(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, DataGenParams var9) throws IOException;

    public static File ensureOutputDirectory(String outputPath) throws IOException {
        if (outputPath == null || outputPath.length() == 0) {
            logger.error((Object)"Empty or null output path");
            return null;
        }
        File outputDir = new File(outputPath);
        logger.info((Object)("Generating test data to directory: " + outputDir.getAbsolutePath()));
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            logger.error((Object)("Failed to create output directory " + outputDir.getAbsolutePath()));
            return null;
        }
        return outputDir;
    }

    public static String getCoreFacilityName(String institutionName, int coreNumber, DataGenParams genParams) {
        return institutionName + " Core Facility " + coreNumber;
    }

    public static String getCoreFacilityURI(String institutionURI, int coreNumber, DataGenParams genParams) {
        return institutionURI + "/CoreFacility/" + coreNumber;
    }

    public static String getResearchFacilityName(String institutionName, int number, DataGenParams genParams) {
        return institutionName + " Research Facility " + number;
    }

    public static String getResearchFacilityURI(String institutionURI, int number, DataGenParams genParams) {
        return institutionURI + "/ResearchFacility/" + number;
    }

    public static String getResourceURI(int resourceCount, String labURI) {
        return labURI + resourceCount;
    }

    public static String getResourceName(int typeCount, OntClass resourceClass) {
        return resourceClass.getLabel(null) + " " + typeCount;
    }

    public List<OntClass> getSubClasses(String uri) {
        if (typeToSubclasses.containsKey(uri)) {
            return typeToSubclasses.get(uri);
        }
        OntModel ontModel = ((JenaEIOntModel)this.eagleiOntModel).getOntModel();
        List subclasses = ontModel.getOntClass(uri).listSubClasses(false).toList();
        if (subclasses == null) {
            logger.error((Object)("Subclasses are null for " + uri));
        }
        typeToSubclasses.put(uri, subclasses);
        return subclasses;
    }

    public static List<EIClass> getTypes(EIOntModel eagleiOntModel, EIURI eiURI, boolean materializeHierarchy) {
        ArrayList<EIClass> types = new ArrayList<EIClass>();
        types.add(eagleiOntModel.getClass(eiURI));
        if (materializeHierarchy) {
            List superclasses = eagleiOntModel.getSuperClasses(eiURI);
            types.addAll(superclasses);
        }
        return types;
    }
}

