/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.server.test;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.server.test.SearchResultWriter;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractSearchServerTest
extends TestCase {
    public static final String RESULTS_DIR = "search.server.test.results.directory";
    public static final String TEST_QUERY_DIRECTORY = "test_queries";
    protected static final Log logger = LogFactory.getLog(AbstractSearchServerTest.class);
    private SearchProvider rootSearchProvider;
    private EIOntModel eagleiOntModel;
    private InstitutionRegistry institutionRegistry;
    private String resultsDir = null;

    protected abstract void setSearchConfiguration();

    protected abstract int getNumberOfInstitutions();

    public void testForDups() throws Exception {
        int start = 0;
        HashSet<String> ids = new HashSet<String>();
        while (true) {
            SearchRequest request = new SearchRequest();
            request.setStartIndex(start);
            SearchResultSet results = this.rootSearchProvider.query(request);
            for (SearchResult result : results.getResults()) {
                AbstractSearchServerTest.assertTrue((String)("Already processed result for entity " + result.getEntity()), (!ids.contains(result.getEntity().getURI().toString()) ? 1 : 0) != 0);
                ids.add(result.getEntity().getURI().toString());
            }
            if ((start += request.getMaxResults()) >= results.getTotalCount()) break;
            logger.info((Object)("About to search at start index " + start + " for total count " + results.getTotalCount()));
        }
    }

    public void testCounts() throws Exception {
        SearchRequest request = new SearchRequest();
        SearchCountRequest countRequest = new SearchCountRequest(request);
        for (EIClass eiClass : this.eagleiOntModel.getTopLevelClasses()) {
            System.out.println("Adding top level class: " + eiClass.getClass().getName());
            countRequest.addCountType(eiClass.getEntity().getURI());
        }
        SearchCounts counts = this.rootSearchProvider.count(countRequest);
        logger.info((Object)counts.toString());
        for (EIClass eiClass : this.eagleiOntModel.getTopLevelClasses()) {
            if (eiClass == null) {
                System.out.println(" eiClass is NULL");
            } else {
                EIEntity ent = eiClass.getEntity();
                if (ent == null) {
                    System.out.println(" eiClass.getEntity is NULL");
                } else {
                    EIURI eiuri = eiClass.getEntity().getURI();
                    if (eiuri == null) {
                        System.out.println(" eiClass.getEntity().getURI() is NULL");
                    }
                }
            }
            AbstractSearchServerTest.assertTrue((boolean)counts.getClassesForCounts().contains(eiClass.getEntity().getURI()));
        }
    }

    public void testQueries() throws Exception {
        File[] files;
        for (File queryFile : files = this.lookupOnClasspath(TEST_QUERY_DIRECTORY)) {
            logger.info((Object)("Loading test queries from: " + queryFile));
            this.testQueries(queryFile, this.resultsDir);
        }
    }

    protected void setUp() throws Exception {
        System.setProperty("org.eaglei.search.provider.lucene.composite.indexer.thread", "false");
        this.resultsDir = System.getProperty(RESULTS_DIR);
        this.setSearchConfiguration();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"});
        this.institutionRegistry = (InstitutionRegistry)context.getBean(InstitutionRegistry.class);
        this.eagleiOntModel = (EIOntModel)context.getBean(EIOntModel.class);
        this.rootSearchProvider = (SearchProvider)context.getBean("rootSearchProvider", SearchProvider.class);
        this.rootSearchProvider.init();
        List institutions = this.institutionRegistry.getInstitutions();
        assert (institutions.size() > 0);
        if (this.getNumberOfInstitutions() == 1) {
            AbstractSearchServerTest.assertTrue((this.institutionRegistry.getInstitution() != null ? 1 : 0) != 0);
            logger.info((Object)("Testing as institution node:   " + this.institutionRegistry.getInstitution()));
        } else {
            AbstractSearchServerTest.assertTrue((String)("Expecting " + this.getNumberOfInstitutions() + " institutions, found " + institutions.size()), (this.getNumberOfInstitutions() == institutions.size() ? 1 : 0) != 0);
            logger.info((Object)("Testing as central node, num institutions:   " + institutions.size()));
        }
    }

    protected void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testQueries(File testQueryFile, String resultsDir) throws Exception {
        List<String> queries = this.loadTestQueryFile(testQueryFile);
        SearchResultWriter writer = null;
        try {
            File dir;
            if (resultsDir != null && (dir = new File(resultsDir)).exists()) {
                File resultsFile = new File(resultsDir, "results_" + testQueryFile.getName());
                writer = new SearchResultWriter(resultsFile);
                writer.writeHeaders();
            }
            for (String query : queries) {
                SearchRequest request = new SearchRequest(new SearchRequest.Term(query));
                SearchResultSet results = this.rootSearchProvider.query(request);
                logger.info((Object)("Found " + results.getTotalCount() + " results for query " + query));
                if (writer == null) continue;
                writer.writeSearchResults(results);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected File[] lookupOnClasspath(String path) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new IOException("Could not locate " + path + " on classpath");
        }
        File file = new File(url.toURI());
        if (file.isDirectory()) {
            return file.listFiles();
        }
        return new File[]{file};
    }

    protected List<String> loadTestQueryFile(File queryFile) throws IOException {
        String line;
        ArrayList<String> queries = new ArrayList<String>();
        LineNumberReader lnr = new LineNumberReader(new FileReader(queryFile));
        while ((line = lnr.readLine()) != null) {
            queries.add(line);
        }
        logger.info((Object)("Loaded " + queries.size() + " queries from " + queryFile));
        return queries;
    }
}

