/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Map;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;

public class MultiDataSetSearchProvider
implements SearchProvider {
    private Map<SearchRequest.DataSet, SearchProvider> mapDSToProvider;

    public MultiDataSetSearchProvider(Map<SearchRequest.DataSet, SearchProvider> mapDSToProvider) {
        this.mapDSToProvider = mapDSToProvider;
    }

    public SearchCounts count(SearchCountRequest request) throws IOException {
        SearchProvider provider = this.mapDSToProvider.get(request.getRequest().getDataset());
        return provider.count(request);
    }

    public void init() throws IOException {
        for (SearchProvider provider : this.mapDSToProvider.values()) {
            provider.init();
        }
    }

    public SearchResultSet query(SearchRequest request) throws IOException {
        SearchProvider provider = this.mapDSToProvider.get(request.getDataset());
        return provider.query(request);
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        SearchProvider provider = this.mapDSToProvider.get(request.getDataset());
        return provider.getResourceCount(request);
    }
}

