/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.request;

import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eaglei.model.EIURI;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.request.EqualityChecker;
import org.eaglei.search.request.SearchResultSerializationTest;
import org.eaglei.search.request.SerializationRoundTrip;

public final class SearchResultSetSerializationTest
extends TestCase {
    public void testGsonRoundTrip() throws Exception {
        SearchResultSet resultSet = SearchResultSetSerializationTest.makeSearchResultSet();
        SerializationRoundTrip.doRoundTrip(resultSet, Serializer.SearchResultSetSerializer, new EqualityChecker<SearchResultSet>(){

            @Override
            public void doEqualsCheck(SearchResultSet expected, SearchResultSet actual) {
                if (expected == null) {
                    Assert.assertNull((Object)actual);
                }
                assert (expected != null);
                Assert.assertTrue((boolean)expected.deepEquals((Object)actual));
            }
        });
    }

    public static final SearchResultSet makeSearchResultSet() {
        SearchResultSet resultSet = new SearchResultSet(new SearchRequest(new SearchRequest.Term(EIURI.create((String)"aksfjlaksjfklasf"))));
        resultSet.setStartIndex(99);
        resultSet.setTotalCount(-12345);
        resultSet.getResults().addAll(Arrays.asList(SearchResultSerializationTest.makeSearchResult(), SearchResultSerializationTest.makeSearchResult(), SearchResultSerializationTest.makeSearchResult(), SearchResultSerializationTest.makeSearchResult()));
        return resultSet;
    }
}

