/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.server.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;

public final class SearchResultWriter {
    protected static final Log logger = LogFactory.getLog(SearchResultWriter.class);
    private final Writer writer;

    public SearchResultWriter(File resultsFile) throws IOException {
        assert (resultsFile != null);
        if (resultsFile.exists()) {
            resultsFile.delete();
        }
        this.writer = new FileWriter(resultsFile);
    }

    public void writeHeaders() throws IOException {
        this.writer.write("Input\t");
        this.writer.write("Match\t");
        this.writer.write("Score\t");
        this.writer.write("Highlight\t");
        this.writer.write("Institution\t");
        this.writer.write("Lab\t");
        this.writer.write("Type\t");
        this.writer.write("URI\n");
    }

    public void writeSearchResults(SearchResultSet resultSet) throws IOException {
        List results = resultSet.getResults();
        SearchRequest request = resultSet.getRequest();
        if (results.isEmpty()) {
            this.writeEmptyResult(request);
        } else {
            boolean first = true;
            for (SearchResult result : results) {
                if (first) {
                    this.writeResult(request.toString(), result);
                } else {
                    this.writeResult("", result);
                }
                first = false;
            }
        }
    }

    private void writeResult(String query, SearchResult result) throws IOException {
        this.writer.write(query + "\t");
        this.writer.write(SearchResultWriter.replaceInvalidChars(result.getEntity().getLabel()) + "\t");
        this.writer.write(result.getRank() + "\t");
        this.writer.write(SearchResultWriter.replaceInvalidChars(result.getHighlight()) + "\t");
        this.writer.write(result.getInstitution().getLabel() + "\t");
        EIEntity lab = result.getProvider();
        if (lab != null) {
            this.writer.write(lab.getLabel() + "\t");
        } else {
            this.writer.write("\t");
        }
        this.writer.write(result.getType().getLabel() + "\t");
        this.writer.write(result.getEntity().getURI().toString() + "\n");
    }

    private static String replaceInvalidChars(String input) {
        String output = input.replace('\n', ' ');
        return output.replace('\t', ' ');
    }

    private void writeEmptyResult(SearchRequest request) throws IOException {
        this.writer.write(request.toString() + "\t");
        this.writer.write("\t");
        this.writer.write("\t");
        this.writer.write("\t");
        this.writer.write("\t");
        this.writer.write("\t");
        this.writer.write("\t");
        this.writer.write("\n");
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

