/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.datagen.AbstractGenerator;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.lucene.LuceneSearchProvider;

public class LuceneSearchProviderIndexer {
    private static final Log logger = LogFactory.getLog(LuceneSearchProviderIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    protected static final boolean INDEX_OBJECT_PROP_LABELS = true;
    public static final String URI = "uri";
    public static final String PREF_TEXT = "pref_text";
    public static final String TEXT = "text";
    public static final String OBJECT_URI_POSTFIX = "_uri";
    public static final String RESOURCE_FLAG = "resourceFlag";
    public static final String INFERRED_TYPE = "inferredType";
    public static final String RELATED = "related";
    public static final String INSTITUTION_URI = "institution_uri";
    public static final String INSTITUTION_LABEL = "institution_label";
    public static final float LOW_BOOST = 0.5f;
    public static final float STANDARD_BOOST = 1.0f;
    public static final float MEDIUM_BOOST = 2.0f;
    public static final float HIGH_BOOST = 5.0f;
    private List<EIURI> prefLabelProperties = new ArrayList<EIURI>();
    private final EIOntModel eagleiOntModel;
    private final IndexWriter iwriter;

    public LuceneSearchProviderIndexer(EIOntModel eagleiOntModel, Analyzer analyzer, Directory directory) throws IOException {
        this.eagleiOntModel = eagleiOntModel;
        this.iwriter = new IndexWriter(directory, analyzer, IndexWriter.MaxFieldLength.LIMITED);
        this.retrieveOntologyMetadata();
    }

    private void retrieveOntologyMetadata() {
        List props = ((JenaEIOntModel)this.eagleiOntModel).getPrefLabelProperties();
        for (Property prop : props) {
            this.prefLabelProperties.add(EIURI.create((String)prop.getURI()));
        }
    }

    public IndexWriter getIndexWriter() {
        return this.iwriter;
    }

    public void commit() throws IOException {
        this.iwriter.optimize();
        this.iwriter.commit();
    }

    public List<EIURI> getRelatedDocuments(EIURI uri) throws IOException {
        BooleanQuery query = new BooleanQuery();
        PhraseQuery propQuery = new PhraseQuery();
        propQuery.add(new Term(RELATED, uri.toString()));
        query.add((Query)propQuery, BooleanClause.Occur.MUST);
        IndexSearcher searcher = new IndexSearcher(this.iwriter.getDirectory(), true);
        searcher.setDefaultFieldSortScoring(true, true);
        final ArrayList<EIURI> uris = new ArrayList<EIURI>();
        Collector collector = new Collector(){
            IndexReader reader;
            int docbase;

            public void setNextReader(IndexReader reader, int docbase) throws IOException {
                this.reader = reader;
                this.docbase = docbase;
            }

            public void collect(int doc) throws IOException {
                Document document = this.reader.document(this.docbase + doc);
                uris.add(EIURI.create((String)document.get(LuceneSearchProviderIndexer.URI)));
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }

            public void setScorer(Scorer scorer) throws IOException {
            }
        };
        searcher.search((Query)query, null, collector);
        return uris;
    }

    protected static String stripObjectURIPostfix(String fieldWithPostfix) {
        assert (fieldWithPostfix != null);
        if (!fieldWithPostfix.endsWith(OBJECT_URI_POSTFIX)) {
            return fieldWithPostfix;
        }
        return fieldWithPostfix.substring(0, fieldWithPostfix.length() - OBJECT_URI_POSTFIX.length());
    }

    public void addIndirectProperties(EIURI uri) throws IOException {
        Document document = this.getDocumentByURI(uri);
        if (document == null) {
            logger.debug((Object)("Failed to find " + uri + " in index"));
            return;
        }
        document.removeFields(TEXT);
        HashMap<String, String> objectPropURIToValue = new HashMap<String, String>();
        HashMap<String, String> datatypePropURIToValue = new HashMap<String, String>();
        for (Fieldable f : document.getFields()) {
            String name = f.name();
            String strValue = f.stringValue();
            if (strValue == null || !LuceneSearchProvider.isPropertyField(name)) continue;
            if (!f.isTokenized()) {
                String objectPropURI = LuceneSearchProviderIndexer.stripObjectURIPostfix(name);
                objectPropURIToValue.put(objectPropURI, strValue);
                continue;
            }
            datatypePropURIToValue.put(name, strValue);
        }
        for (String value : datatypePropURIToValue.values()) {
            LuceneSearchProviderIndexer.addToText(document, value);
        }
        for (String propURI : objectPropURIToValue.keySet()) {
            document.removeFields(propURI);
        }
        for (String propURI : objectPropURIToValue.keySet()) {
            String propValue = (String)objectPropURIToValue.get(propURI);
            Document objectDoc = this.getDocumentByURI(EIURI.create((String)propValue));
            if (objectDoc != null) {
                for (Fieldable prefTextField : objectDoc.getFieldables(PREF_TEXT)) {
                    String prefText = prefTextField.stringValue();
                    LuceneSearchProviderIndexer.addToText(document, prefText);
                    Field objectPropLabel = new Field(propURI.toString(), prefText, Field.Store.YES, Field.Index.ANALYZED);
                    objectPropLabel.setBoost(0.5f);
                    document.add((Fieldable)objectPropLabel);
                }
                continue;
            }
            EIClass eiClass = this.eagleiOntModel.getClass(EIURI.create((String)propValue));
            if (eiClass == null) continue;
            String prefText = eiClass.getEntity().getLabel();
            LuceneSearchProviderIndexer.addToText(document, prefText);
            Field objectPropLabel = new Field(propURI.toString(), prefText, Field.Store.YES, Field.Index.ANALYZED);
            objectPropLabel.setBoost(0.5f);
            document.add((Fieldable)objectPropLabel);
        }
        LuceneSearchProviderIndexer.addToText(document, document.get(INSTITUTION_LABEL));
        String typeURI = document.get(RDF.type.getURI() + OBJECT_URI_POSTFIX);
        this.indexTypes(document, EIURI.create((String)typeURI), true, false);
        this.iwriter.updateDocument(new Term(URI, uri.toString()), document);
    }

    private Document getDocumentByURI(EIURI uri) throws IOException {
        PhraseQuery propQuery = new PhraseQuery();
        propQuery.add(new Term(URI, uri.toString()));
        IndexSearcher searcher = new IndexSearcher(this.iwriter.getDirectory(), true);
        searcher.setDefaultFieldSortScoring(true, true);
        TopDocs docs = searcher.search((Query)propQuery, 1);
        if (docs.totalHits == 0) {
            return null;
        }
        ScoreDoc scoreDoc = docs.scoreDocs[0];
        Document document = searcher.doc(scoreDoc.doc);
        return document;
    }

    private void deleteDocumentByURI(EIURI uri) throws IOException {
        PhraseQuery query = new PhraseQuery();
        query.add(new Term(URI, uri.toString()));
        this.iwriter.deleteDocuments((Query)query);
    }

    protected static boolean isDeletedSearchResult(SearchResult result) {
        return result.getType().getURI().toString().equals("http://eagle-i.org/ont/repo/1.0/isDeleted");
    }

    public void indexSearchResult(SearchResult result, boolean materializeTypes) throws IOException {
        EIURI uri = result.getEntity().getURI();
        this.deleteDocumentByURI(uri);
        if (LuceneSearchProviderIndexer.isDeletedSearchResult(result)) {
            return;
        }
        Document doc = new Document();
        doc.add((Fieldable)new Field(URI, uri.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        EIEntity institutionEntity = result.getInstitution();
        doc.add((Fieldable)new Field(INSTITUTION_URI, institutionEntity.getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(INSTITUTION_LABEL, institutionEntity.getLabel(), Field.Store.YES, Field.Index.ANALYZED));
        LuceneSearchProviderIndexer.addToText(doc, institutionEntity.getLabel());
        EIEntity typeEntity = result.getType();
        EIClass typeClass = this.eagleiOntModel.getClass(typeEntity.getURI());
        if (typeClass == null) {
            logger.error((Object)("Resource " + result.getEntity() + " with type " + typeClass + " is not a valid eagle-i class"));
            return;
        }
        doc.add((Fieldable)new Field(RESOURCE_FLAG, String.valueOf(typeClass.isEagleIResource()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(RDF.type.getURI() + OBJECT_URI_POSTFIX, typeEntity.getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        this.indexTypes(doc, typeEntity.getURI(), materializeTypes, true);
        for (EIURI propURI : result.getDataTypeProperties()) {
            if (this.shouldIgnore(typeClass, propURI)) continue;
            boolean addToPrefText = this.prefLabelProperties.contains(propURI);
            Set values = result.getDataTypeProperty(propURI);
            for (String value : values) {
                doc.add((Fieldable)new Field(propURI.toString(), value.toString(), Field.Store.YES, Field.Index.ANALYZED));
                if (addToPrefText) {
                    LuceneSearchProviderIndexer.addToPrefText(doc, value);
                }
                LuceneSearchProviderIndexer.addToText(doc, value);
            }
        }
        for (EIURI propURI : result.getObjectProperties()) {
            if (this.shouldIgnore(typeClass, propURI)) continue;
            Set values = result.getObjectProperty(propURI);
            for (EIURI value : values) {
                doc.add((Fieldable)new Field(propURI.toString() + OBJECT_URI_POSTFIX, value.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field(RELATED, value.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        this.iwriter.addDocument(doc);
    }

    private void indexTypes(Document doc, EIURI typeURI, boolean materializeTypes, boolean indexURIs) {
        for (EIClass type : AbstractGenerator.getTypes((EIOntModel)this.eagleiOntModel, (EIURI)typeURI, (boolean)materializeTypes)) {
            String label;
            String uri = type.getEntity().getURI().toString();
            if (indexURIs) {
                doc.add((Fieldable)new Field(INFERRED_TYPE, uri, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
            if ((label = this.eagleiOntModel.getPreferredLabel(type.getEntity().getURI())) == null) continue;
            if (uri.equals(typeURI.toString())) {
                LuceneSearchProviderIndexer.addToPrefText(doc, label);
            } else {
                doc.add((Fieldable)new Field(RDF.type.getURI(), label, Field.Store.YES, Field.Index.ANALYZED));
            }
            LuceneSearchProviderIndexer.addToText(doc, label);
        }
    }

    private static void addToText(Document doc, String value) {
        Field field = new Field(TEXT, value, Field.Store.YES, Field.Index.ANALYZED);
        field.setBoost(1.0f);
        doc.add((Fieldable)field);
    }

    private static void addToPrefText(Document doc, String value) {
        Field field = new Field(PREF_TEXT, value, Field.Store.YES, Field.Index.ANALYZED);
        field.setBoost(5.0f);
        doc.add((Fieldable)field);
    }

    private boolean shouldIgnore(EIClass typeClass, EIURI uri) {
        return false;
    }
}

