/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.eaglei.lexical.lucene.LuceneUtils;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderUtil;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;

public final class LuceneSearchProvider
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(LuceneSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final boolean RETRIEVE_PROPERTIES = false;
    private static final int MAX_HIGHLIGHT_MATCHES = 3;
    private final EIOntModel eagleiOntModel;
    private Directory dir;
    private Analyzer analyzer;
    private QueryParser prefTextParser;
    private QueryParser textParser;
    private QueryParser indirectTextParser;
    private List<EIURI> prefLabelProperties = new ArrayList<EIURI>();

    public LuceneSearchProvider(EIOntModel eagleiOntModel, Directory dir, Analyzer analyzer) throws IOException {
        assert (dir != null);
        assert (analyzer != null);
        this.eagleiOntModel = eagleiOntModel;
        this.dir = dir;
        this.analyzer = analyzer;
        this.textParser = new QueryParser(Version.LUCENE_30, "text", this.analyzer);
        this.prefTextParser = new QueryParser(Version.LUCENE_30, "pref_text", this.analyzer);
        this.retrieveOntologyMetadata();
    }

    public void init() throws IOException {
    }

    private void retrieveOntologyMetadata() {
        List props = ((JenaEIOntModel)this.eagleiOntModel).getPrefLabelProperties();
        for (Property prop : props) {
            this.prefLabelProperties.add(EIURI.create((String)prop.getURI()));
        }
    }

    public SearchResultSet query(SearchRequest request) throws IOException {
        return this.query(request, true);
    }

    private SearchResultSet query(SearchRequest request, boolean createResults) throws IOException {
        assert (request != null);
        Query query = null;
        try {
            query = this.createQuery(request, null);
        }
        catch (ParseException pe) {
            throw new IOException(pe.getLocalizedMessage());
        }
        if (query == null) {
            return new SearchResultSet(request);
        }
        return this.executeSearch(request, query, createResults);
    }

    public SearchCounts count(SearchCountRequest request) throws IOException {
        assert (request != null);
        SearchRequest searchRequest = request.getRequest();
        SearchCounts counts = new SearchCounts(searchRequest);
        for (EIURI type : request.getCountTypes()) {
            SearchRequest countRequest = new SearchRequest(searchRequest.toURLParams());
            if (type == null) {
                countRequest.setBinding(null);
            } else {
                countRequest.setBinding(new SearchRequest.TypeBinding(type));
            }
            SearchResultSet results = this.query(countRequest, false);
            counts.setClassCount(type, results.getTotalCount());
        }
        return counts;
    }

    private TopFieldDocs retrieveDocs(IndexSearcher searcher, SearchRequest request, Query query) throws IOException {
        searcher.setDefaultFieldSortScoring(true, true);
        TopFieldDocs docs = searcher.search(query, null, request.getStartIndex() + request.getMaxResults(), Sort.RELEVANCE);
        logger.debug((Object)("Found " + docs.totalHits + " matches"));
        return docs;
    }

    private SearchResultSet executeSearch(SearchRequest request, Query query, boolean createResults) throws IOException {
        SearchResultSet results = new SearchResultSet(request);
        IndexSearcher searcher = new IndexSearcher(this.dir, true);
        TopFieldDocs docs = this.retrieveDocs(searcher, request, query);
        results.setTotalCount(docs.totalHits);
        results.setStartIndex(request.getStartIndex());
        if (!createResults) {
            return results;
        }
        Highlighter highlighter = new Highlighter((Scorer)new QueryScorer(query));
        int cap = request.getStartIndex() + request.getMaxResults();
        for (int i = request.getStartIndex(); i < cap && i < docs.scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = docs.scoreDocs[i];
            Document document = searcher.doc(scoreDoc.doc);
            float score = scoreDoc.score;
            String resource = document.get("uri");
            String label = null;
            for (EIURI prop : this.prefLabelProperties) {
                String[] values = document.getValues(prop.toString());
                if (values.length <= 0) continue;
                label = values[0];
                break;
            }
            EIEntity resourceEntity = EIEntity.create((EIURI)EIURI.create((String)resource), label);
            String institution_uri = document.get("institution_uri");
            String institution_label = document.get("institution_label");
            EIEntity institutionEntity = EIEntity.create((EIURI)EIURI.create((String)institution_uri), (String)institution_label);
            String type = document.get(RDF.type.getURI() + "_uri");
            if (type == null) {
                logger.error((Object)("Null rdf:type for " + resource));
                continue;
            }
            EIClass eiClass = this.eagleiOntModel.getClass(EIURI.create((String)type));
            if (eiClass == null) {
                logger.error((Object)("Unable to locate resource class " + type + " for " + resource));
                continue;
            }
            SearchResult result = new SearchResult(resourceEntity, eiClass.getEntity(), null, institutionEntity);
            for (Fieldable f : document.getFields()) {
                String name = f.name();
                String strValue = f.stringValue();
                if (strValue == null || !LuceneSearchProvider.isPropertyField(name)) continue;
                if (f.isTokenized()) {
                    String labURI;
                    if (!LuceneSearchProvider.isLabProperty(name) || (labURI = document.get(name + "_uri")) == null) continue;
                    EIEntity labEntity = EIEntity.create((EIURI)EIURI.create((String)labURI), (String)strValue);
                    result.setLab(labEntity);
                    continue;
                }
                EIURI propURI = EIURI.create((String)LuceneSearchProviderIndexer.stripObjectURIPostfix(name));
            }
            String highlight = this.computeHighlight(highlighter, request, query, document, type);
            if (highlight != null) {
                result.setHighlight(highlight);
            }
            result.setURL(resource);
            result.setRank(score);
            if (results.getResults().contains(result)) {
                logger.error((Object)"Found duplicate result");
            }
            results.getResults().add(result);
        }
        return results;
    }

    private static boolean isLabProperty(String uri) {
        if (uri.equals("http://www.obofoundry.org/ro/ro.owl#located_in")) {
            return true;
        }
        if (uri.equals("http://purl.obolibrary.org/obo/ERO_0000070")) {
            return true;
        }
        return uri.equals("http://purl.obolibrary.org/obo/ERO_0000390");
    }

    private void addLab(SearchResult result, String labURI) throws IOException {
        BooleanQuery query = new BooleanQuery();
        PhraseQuery resourceQuery = new PhraseQuery();
        resourceQuery.add(new Term("uri", labURI));
        query.add((Query)resourceQuery, BooleanClause.Occur.MUST);
        IndexSearcher searcher = new IndexSearcher(this.dir, true);
        searcher.setDefaultFieldSortScoring(true, true);
        TopFieldDocs docs = searcher.search((Query)query, null, 1, Sort.RELEVANCE);
        if (docs.totalHits > 0) {
            ScoreDoc scoreDoc = docs.scoreDocs[0];
            Document document = searcher.doc(scoreDoc.doc);
            float score = scoreDoc.score;
            String resource = document.get("uri");
            String label = null;
            for (EIURI prop : this.prefLabelProperties) {
                String[] values = document.getValues(prop.toString());
                if (values.length <= 0) continue;
                label = values[0];
                break;
            }
            EIEntity labEntity = EIEntity.create((EIURI)EIURI.create((String)resource), label);
            result.setLab(labEntity);
        }
    }

    protected static boolean isPropertyField(String fieldName) {
        if (fieldName.equals("uri")) {
            return false;
        }
        if (fieldName.equals("text")) {
            return false;
        }
        if (fieldName.equals("pref_text")) {
            return false;
        }
        if (fieldName.equals("inferredType")) {
            return false;
        }
        if (fieldName.equals("institution_label")) {
            return false;
        }
        if (fieldName.equals("institution_uri")) {
            return false;
        }
        if (fieldName.equals("related")) {
            return false;
        }
        return !fieldName.equals("resourceFlag");
    }

    private String computeHighlight(Highlighter highlighter, SearchRequest request, Query query, Document document, String typeURI) {
        SearchRequest.Term term = request.getTerm();
        SearchRequest.TypeBinding binding = request.getBinding();
        if (term != null && term.getQuery() != null || binding != null && !binding.getDataTypeProperties().isEmpty()) {
            StringBuilder highlights = new StringBuilder();
            boolean firstHighlight = true;
            int totalHighlightMatches = 0;
            for (Fieldable f : document.getFields()) {
                String propLabel;
                String highlight;
                String name = f.name();
                String strValue = f.stringValue();
                if (strValue == null || !LuceneSearchProvider.isPropertyField(name) || !f.isTokenized() || (highlight = this.getHighlightForField(highlighter, name, strValue, document)) == null) continue;
                if (firstHighlight) {
                    highlights.append("...");
                    firstHighlight = false;
                }
                if ((propLabel = this.getPropertyLabel(typeURI, name)) != null) {
                    highlights.append(propLabel + ": ");
                }
                highlights.append(highlight);
                highlights.append("...");
                if (totalHighlightMatches++ < 3) continue;
                break;
            }
            return highlights.toString();
        }
        return null;
    }

    private String getPropertyLabel(String typeURI, String propURI) {
        if (propURI.equals(RDF.type.getURI())) {
            return "type";
        }
        for (EIProperty prop : this.eagleiOntModel.getProperties(EIURI.create((String)typeURI))) {
            if (!prop.getEntity().getURI().toString().equals(propURI)) continue;
            return prop.getEntity().getLabel();
        }
        return null;
    }

    private String getHighlightForField(Highlighter highlighter, String fieldName, String fieldValue, Document document) {
        try {
            String highlight = highlighter.getBestFragment(this.analyzer, fieldName, fieldValue);
            if (highlight != null) {
                return highlight;
            }
        }
        catch (InvalidTokenOffsetsException itoe) {
            logger.error((Object)itoe);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
        }
        return null;
    }

    private Query createQuery(SearchRequest request) throws ParseException {
        return this.createQuery(request, null);
    }

    private Query createQuery(SearchRequest request, SearchResultSet results) throws ParseException {
        SearchRequest.TypeBinding binding;
        EIURI typeURI;
        SearchRequest.Term term = request.getTerm();
        EIURI institution = request.getInstitution();
        BooleanQuery query = new BooleanQuery();
        PhraseQuery resourceFlagQuery = new PhraseQuery();
        resourceFlagQuery.add(new Term("resourceFlag", Boolean.TRUE.toString()));
        query.add((Query)resourceFlagQuery, BooleanClause.Occur.MUST);
        if (institution != null) {
            PhraseQuery institutionQuery = new PhraseQuery();
            institutionQuery.add(new Term("institution_uri", institution.toString()));
            query.add((Query)institutionQuery, BooleanClause.Occur.MUST);
        }
        if (term != null) {
            BooleanQuery termQuery = new BooleanQuery();
            query.add((Query)termQuery, BooleanClause.Occur.MUST);
            if (term.getQuery() != null) {
                Query strTextQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.textParser, (String)term.getQuery());
                termQuery.add(strTextQuery, BooleanClause.Occur.SHOULD);
                Query strPrefTextQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.prefTextParser, (String)term.getQuery());
                termQuery.add(strPrefTextQuery, BooleanClause.Occur.SHOULD);
            }
            if (term.getURI() != null) {
                EIURI uri = term.getURI();
                EIClass eiClass = this.eagleiOntModel.getClass(uri);
                if (eiClass != null) {
                    PhraseQuery typeQuery = new PhraseQuery();
                    typeQuery.add(new Term("inferredType", uri.toString()));
                    termQuery.add((Query)typeQuery, BooleanClause.Occur.SHOULD);
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (String label : this.eagleiOntModel.getLabels(uri)) {
                        if (!first) {
                            sb.append(" ");
                        }
                        first = false;
                        sb.append(label);
                    }
                    Query strTextQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.textParser, (String)sb.toString());
                    termQuery.add(strTextQuery, BooleanClause.Occur.SHOULD);
                    Query strPrefTextQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.prefTextParser, (String)sb.toString());
                    termQuery.add(strPrefTextQuery, BooleanClause.Occur.SHOULD);
                }
                PhraseQuery propQuery = new PhraseQuery();
                propQuery.add(new Term("related", uri.toString()));
                termQuery.add((Query)propQuery, BooleanClause.Occur.SHOULD);
            }
        }
        if ((typeURI = SearchProviderUtil.getType((SearchRequest)request)) != null) {
            PhraseQuery typeQuery = new PhraseQuery();
            typeQuery.add(new Term("inferredType", typeURI.toString()));
            query.add((Query)typeQuery, BooleanClause.Occur.MUST);
        }
        if ((binding = request.getBinding()) != null) {
            String constraint;
            for (EIURI prop : binding.getDataTypeProperties()) {
                constraint = binding.getDataTypeProperty(prop);
                QueryParser propParser = new QueryParser(Version.LUCENE_30, prop.toString(), this.analyzer);
                Query propQuery = propParser.parse(constraint);
                query.add(propQuery, BooleanClause.Occur.MUST);
            }
            for (EIURI prop : binding.getObjectProperties()) {
                constraint = binding.getObjectProperty(prop);
                PhraseQuery propQuery = new PhraseQuery();
                propQuery.add(new Term(prop.toString() + "_uri", constraint.toString()));
                query.add((Query)propQuery, BooleanClause.Occur.MUST);
            }
        }
        if (query.clauses().isEmpty()) {
            MatchAllDocsQuery allDocsQuery = new MatchAllDocsQuery();
            query.add((Query)allDocsQuery, BooleanClause.Occur.MUST);
            return query;
        }
        if (DEBUG) {
            logger.debug((Object)("Query: " + query.toString()));
        }
        return query;
    }
}

