/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.lexical.lucene.PorterStemAnalyzer;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.lucene.LuceneGenerator;
import org.eaglei.search.provider.lucene.LuceneSearchProvider;
import org.eaglei.services.InstitutionRegistry;

public final class LuceneSearchProviderFactory {
    private static final Log logger = LogFactory.getLog(LuceneSearchProviderFactory.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String LUCENE_INDEX_DIR_PROP = "org.eaglei.search.provider.lucene.index.dir";

    public static LuceneSearchProvider createProviderForGeneratedData(InstitutionRegistry institutionRegistry, EIOntModel eagleiOntModel, DataGenParams datagenParams) throws IOException {
        Analyzer analyzer = LuceneSearchProviderFactory.getAnalyzer();
        Directory dir = LuceneSearchProviderFactory.getDirectory();
        LuceneGenerator generator = new LuceneGenerator(eagleiOntModel, analyzer, dir);
        if (datagenParams == null) {
            generator.generate(LuceneSearchProviderFactory.getDefaultDataGenParams(institutionRegistry));
        } else {
            generator.generate(datagenParams);
        }
        return new LuceneSearchProvider(eagleiOntModel, dir, analyzer);
    }

    private static DataGenParams getDefaultDataGenParams(InstitutionRegistry institutionRegistry) {
        DataGenParams params = DataGenParams.createForAllInstitutions((List)institutionRegistry.getInstitutions());
        params.setCoreFacilityRange(1, 3);
        params.setResearchFacilityRange(0, 0);
        params.setMaterializeHierarchy(true);
        return params;
    }

    public static Directory getDirectory() throws IOException {
        String indexDir = System.getProperty(LUCENE_INDEX_DIR_PROP);
        if (indexDir != null) {
            File dir = new File(indexDir);
            if (DEBUG) {
                logger.debug((Object)("Using Lucene index directory: " + dir.getAbsolutePath()));
            }
            if (!dir.exists()) {
                dir.mkdirs();
            } else if (!dir.isDirectory()) {
                logger.error((Object)"Specified Lucene index directory is not a directory");
                return new RAMDirectory();
            }
            return FSDirectory.open((File)dir);
        }
        if (DEBUG) {
            logger.debug((Object)"Using Lucene RAMDirectory");
        }
        return new RAMDirectory();
    }

    public static Analyzer getAnalyzer() {
        return new PorterStemAnalyzer();
    }
}

