/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.datagen.AbstractGenerator;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;

public class LuceneGenerator
extends AbstractGenerator {
    private static final Log logger = LogFactory.getLog(LuceneGenerator.class);
    private LuceneSearchProviderIndexer indexer;

    public LuceneGenerator(EIOntModel eagleiOntModel, Analyzer analyzer, Directory directory) throws IOException {
        super(eagleiOntModel);
        this.indexer = new LuceneSearchProviderIndexer(eagleiOntModel, analyzer, directory);
    }

    public void closeStorage() throws IOException {
        this.indexer.commit();
    }

    public int generateForInstitution(String uri, String label, DataGenParams genParams) throws IOException {
        int total = super.generateForInstitution(uri, label, genParams);
        return total;
    }

    public int generateLab(String institutionURI, String institutionLabel, String labLabel, String labURI, String labURL, String labTypeURI, DataGenParams genParams) throws IOException {
        int total = super.generateLab(institutionURI, institutionLabel, labLabel, labURI, labURL, labTypeURI, genParams);
        EIEntity labEntity = EIEntity.create((EIURI)EIURI.create((String)labURI), (String)labLabel);
        EIEntity institutionEntity = EIEntity.create((EIURI)EIURI.create((String)institutionURI), (String)institutionLabel);
        EIClass typeClass = this.eagleiOntModel.getClass(EIURI.create((String)labTypeURI));
        EIEntity typeEntity = typeClass.getEntity();
        SearchResult result = new SearchResult(labEntity, typeEntity, labEntity, institutionEntity);
        result.addDataTypeProperty(EIURI.create((String)RDFS.label.getURI()), labLabel);
        this.indexer.indexSearchResult(result, genParams.getMaterializeHierarchy());
        return total + 1;
    }

    public void generateResource(String institutionURI, String institutionLabel, String resourceLabel, String resourceURI, String resourceTypeURI, String resourceURL, String labName, String labURI, DataGenParams genParams) throws IOException {
        EIEntity resourceEntity = EIEntity.create((EIURI)EIURI.create((String)resourceURI), (String)resourceLabel);
        EIEntity labEntity = EIEntity.create((EIURI)EIURI.create((String)labURI), (String)labName);
        EIEntity institutionEntity = EIEntity.create((EIURI)EIURI.create((String)institutionURI), (String)institutionLabel);
        EIClass typeClass = this.eagleiOntModel.getClass(EIURI.create((String)resourceTypeURI));
        EIEntity typeEntity = typeClass.getEntity();
        SearchResult result = new SearchResult(resourceEntity, typeEntity, labEntity, institutionEntity);
        result.addDataTypeProperty(EIURI.create((String)RDFS.label.getURI()), resourceLabel);
        this.indexer.indexSearchResult(result, genParams.getMaterializeHierarchy());
    }
}

