package org.eaglei.search.provider.lucene;

import java.io.IOException;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;

import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.services.InstitutionRegistry;

/**
 * Factory methods for creating LuceneSearchProvider from generated data.
 * TODO move this logic into test
 * @author frost
 */
public final class LuceneSearchProviderFactory {
    
    /**
     * Creates a LuceneProvider for generated data.
     * @param datagenParams Generation params
     * @return The LuceneProvider
     * @throws IOException Thrown if an error is encountered creating the provider.
     */
    public static LuceneSearchProvider createProviderForGeneratedData(final InstitutionRegistry institutionRegistry, final EIOntModel eagleiOntModel, final DataGenParams datagenParams) throws IOException {
        final Analyzer analyzer = LuceneSearchProviderProperties.getAnalyzer();
        final Directory dir = LuceneSearchProviderProperties.getDirectory();
        final LuceneGenerator generator = new LuceneGenerator(eagleiOntModel, analyzer, dir);
        if (datagenParams == null) {
            generator.generate(getDefaultDataGenParams(institutionRegistry)); 
        } else {
            generator.generate(datagenParams);
        }
        return new LuceneSearchProvider(eagleiOntModel, dir, analyzer); 
    }
    
    private static DataGenParams getDefaultDataGenParams(InstitutionRegistry institutionRegistry) {
        final DataGenParams params = DataGenParams.createForAllInstitutions(institutionRegistry.getInstitutions());
        params.setCoreFacilityRange(1, 3);
        params.setResearchFacilityRange(0, 0);
        params.setMaterializeHierarchy(true); 
        return params;
    }
}