/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.lexical.lucene.PorterStemAnalyzer;
import org.eaglei.search.config.SearchProperties;

public final class LuceneSearchProviderProperties
extends SearchProperties {
    private static final Log logger = LogFactory.getLog(LuceneSearchProviderProperties.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String UPDATE_FREQUENCY = "org.eaglei.search.provider.lucene.composite.update.freq";
    public static final long DEFAULT_UPDATE_FREQ = 10000L;
    public static final String LUCENE_INDEX_DIR_PROP = "org.eaglei.search.provider.lucene.index.dir";

    public static Directory getDirectory() throws IOException {
        String indexDir = System.getProperty(LUCENE_INDEX_DIR_PROP);
        if (indexDir != null) {
            File dir = new File(indexDir);
            if (DEBUG) {
                logger.debug((Object)("Using Lucene index directory: " + dir.getAbsolutePath()));
            }
            if (!dir.exists()) {
                dir.mkdirs();
            } else if (!dir.isDirectory()) {
                logger.error((Object)"Specified Lucene index directory is not a directory");
                return new RAMDirectory();
            }
            return FSDirectory.open((File)dir);
        }
        if (DEBUG) {
            logger.debug((Object)"Using Lucene RAMDirectory");
        }
        return new RAMDirectory();
    }

    public static Analyzer getAnalyzer() {
        return new PorterStemAnalyzer();
    }
}

