package org.eaglei.search.provider.lucene.harvest;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.JenaModelConfig;
import org.eaglei.search.harvest.DataHarvester;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.search.provider.lucene.search.ClassUsageCache;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.NodeConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Lazy;

@Configuration
@ImportResource("classpath:search-common-config.xml")
@Import(JenaModelConfig.class)
public class DataHarvesterConfig {

	private static final Log logger = LogFactory.getLog(DataHarvesterConfig.class);
	    
    private @Autowired EIOntModel eagleiOntModel;
    private @Autowired InstitutionRegistry institutionRegistry;

    @Lazy @Bean
    public PollingDataHarvester dataHarvester() {
    	PollingDataHarvester result;
        if (institutionRegistry.getInstitution() != null) {
            EIEntity institution = institutionRegistry.getInstitution();
        	result = createInstitutionDataHarvester(institution);
        } else {
        	List<EIEntity> nodesToHarvest = null;
        	if (System.getProperty("org.eaglei.harvester.nodes") != null) {
        		String[] nodeIdsToHarvest = System.getProperty("org.eaglei.harvester.nodes").split(",");
        		nodesToHarvest = new ArrayList<EIEntity>(nodeIdsToHarvest.length);
        		for (String nodeId : nodeIdsToHarvest) {
        			EIEntity entity = institutionRegistry.getInstitution(nodeId.trim());
        			if (entity != null) {
        				nodesToHarvest.add(entity);
        			}
        		}
        	}
        	MultiDataSourceStreamHarvester multiHarvister = new MultiDataSourceStreamHarvester();
	    	for (EIEntity institution : institutionRegistry.getInstitutions()) {
	    		if (nodesToHarvest != null) {
	    			if (!nodesToHarvest.contains(institution)) {
	    				continue;
	    			}
	    		}
	    		multiHarvister.addDataHarvester(createInstitutionDataHarvester(institution));
	    	}
	    	result = multiHarvister;
        }
        return result;
    }
    
    private PollingDataHarvester createInstitutionDataHarvester(EIEntity institution) {
    	PollingDataHarvester harvester;
        if (Boolean.parseBoolean(System.getProperty("org.eaglei.harvester.file", "false"))) {
            // TODO: Move into test
            harvester = new FileStreamHarvester(eagleiOntModel, institution, institutionRegistry);
        } else {
            harvester = new RepositoryStreamHarvester(eagleiOntModel, institution, institutionRegistry);
        } 
        return harvester;
    }
    
}
