package org.eaglei.search.provider.ncbi.gene;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.NCBIEUtils.DocSummary;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneProvider.GeneSummary;
import org.eaglei.search.provider.ncbi.mesh.NCBIMeSHProvider;
import org.eaglei.services.InstitutionRegistry;

/**
 * Subclass of NCBISearchProvider that wraps an NCBIGeneProvider.
 *
 * @author rfrost
 */
public final class NCBIGeneSearchProvider extends NCBISearchProvider {

    private static final Log logger = LogFactory.getLog(NCBIGeneSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public static final String GENE_URI = "http://purl.obolibrary.org/obo/ERO_0000223";
    private final EIEntity entrezGeneEntity;
    private final EIEntity geneEntity;    
    private final EIEntity locationEntity;        
    
    public NCBIGeneSearchProvider(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        super(new NCBIGeneProvider(), eagleiOntModel, registry);
        this.geneEntity = eagleiOntModel.getClass(EIURI.create(GENE_URI)).getEntity();
        this.entrezGeneEntity = EIEntity.create(EIURI.create(NCBIGeneProvider.GENE_URL), "Entrez Gene");
        this.locationEntity = EIEntity.create(EIURI.create(NCBIGeneProvider.GENE_URL), NCBIGeneProvider.ENTREZ_GENE);
    }
    
    public EIEntity getType() {
        // TODO the old gene entity is now obsolete
        //return geneEntity;
        return entrezGeneEntity;
    }

    @Override
    public boolean shouldAddResults(SearchRequest request)
            throws IOException {
        return true;
        /*
        final EIURI type = getType(request);
        if (type == null) { 
            return false;
        }
        return isType(type, geneEntity.getURI());
        */
    }
     
    @Override
    protected SearchResult createSearchResultForDocSummary(DocSummary sum)
            throws IOException {
        final GeneSummary geneSum = new GeneSummary(sum);
        final SearchResult searchResult = new SearchResult(EIEntity.create(geneSum.url, geneSum.label), entrezGeneEntity, null, locationEntity);
        searchResult.setURL(geneSum.url);
        searchResult.setHighlight(geneSum.orgname.value + ": " + geneSum.desc.value);
        return searchResult;
    }
    
    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return getQuery(request, false, Collections.EMPTY_SET, false);
    }    

}
