package org.eaglei.search.provider.ncbi.pubmed;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.NCBIEUtils.DocSummary;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedProvider.PubMedSummary;
import org.eaglei.services.InstitutionRegistry;

/**
 * Subclass of NCBISearchProvider that wraps an NCBIPubMedProvider.
 *
 * @author rfrost
 */
public final class NCBIPubMedSearchProvider extends NCBISearchProvider {

    private static final Log logger = LogFactory.getLog(NCBIPubMedProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public static final String DOCUMENT_URI = "http://purl.obolibrary.org/obo/IAO_0000310";
    private final EIEntity docEntity;
    public static final String PUBLICATION_URI = "http://purl.obolibrary.org/obo/IAO_0000311";
    private final EIEntity pubEntity;   
    private final EIEntity locationEntity;        

    public NCBIPubMedSearchProvider(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        super(new NCBIPubMedProvider(), eagleiOntModel, registry);
        this.docEntity = eagleiOntModel.getClass(EIURI.create(DOCUMENT_URI)).getEntity();        
        this.pubEntity = eagleiOntModel.getClass(EIURI.create(PUBLICATION_URI)).getEntity();  
        this.locationEntity = EIEntity.create(EIURI.create(NCBIPubMedProvider.PUBMED_URL), NCBIPubMedProvider.NCBI_PUBMED_NAME);        
    }    
    
    public EIEntity getType() {
        return pubEntity;
    }
    
    @Override
    public boolean shouldAddResults(SearchRequest request)
            throws IOException {
        return true;
        /*
        final EIURI type = getType(request);
        if (type == null) { 
            return false;
        }
        return isType(type, this.docEntity.getURI()) && request.getTerm() != null;
        */
    }    
    
    @Override
    protected SearchResult createSearchResultForDocSummary(DocSummary sum)
            throws IOException {
        final PubMedSummary pubMedSum = new PubMedSummary(sum);
        final SearchResult searchResult = new SearchResult(EIEntity.create(pubMedSum.url, pubMedSum.label), pubEntity, null, locationEntity);
        searchResult.setURL(pubMedSum.url);
        searchResult.setHighlight(pubMedSum.descrip);
        
        return searchResult;
    }
    
    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return getQuery(request, false, Collections.EMPTY_SET, true);
    }   
    
}
