package org.eaglei.search.provider.ncbi.taxonomy;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary.ESummaryResult;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.taxonomy.NCBITaxonomyProvider.TaxonomySummary;
import org.eaglei.services.InstitutionRegistry;

/**
 * Subclass of NCBISearchProvider that wraps an NCBITaxonomyProvider.
 *
 * @author rfrost
 */
public final class NCBITaxonomySearchProvider extends NCBISearchProvider {

    private static final Log logger = LogFactory.getLog(NCBITaxonomyProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public static final String ORGANISM_URI = "http://purl.obolibrary.org/obo/OBI_0100026";
    private final EIEntity orgEntity;
    private final EIEntity locationEntity;        
    
    public NCBITaxonomySearchProvider(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        super(new NCBITaxonomyProvider(), eagleiOntModel, registry);
        this.orgEntity = eagleiOntModel.getClass(EIURI.create(ORGANISM_URI)).getEntity();        
        this.locationEntity = EIEntity.create(EIURI.create(NCBITaxonomyProvider.TAXONOMY_URL), NCBITaxonomyProvider.NCBI_TAXONOMY_NAME);        
    }  
    
    public EIEntity getType() {
        return orgEntity;
    }    
    
    @Override
    public boolean shouldAddResults(SearchRequest request)
            throws IOException {
        final EIURI type = getType(request);
        if (type == null) { 
            return false;
        }
        return isType(type, orgEntity.getURI());
    }
    
    @Override
    protected SearchResult createSearchResultForDocSummary(ESummaryResult sum)
            throws IOException {
        final TaxonomySummary taxonomySum = new TaxonomySummary(sum);
        final SearchResult searchResult = new SearchResult(EIEntity.create(taxonomySum.url, taxonomySum.label), orgEntity, null, locationEntity);
        searchResult.setURL(taxonomySum.url);
        searchResult.setHighlight(taxonomySum.sciName.value);
        
        return searchResult;
    }
    
    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return getQuery(request, true, Collections.singleton(orgEntity.getURI()), false);
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        // TODO Auto-generated method stub
        return null;
    }

	@Override
	public ClassCountResult getProviderTypeCount(SearchRequest request) {
		// TODO Auto-generated method stub
		return null;
	}    
}
