/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.mesh;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.mesh.NCBIMeSHProvider;
import org.eaglei.services.InstitutionRegistry;

public final class NCBIMeSHSearchProvider
extends NCBISearchProvider {
    private static final Log logger = LogFactory.getLog(NCBIMeSHSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String DISEASE_URI = "http://purl.obolibrary.org/obo/OBI_1110055";
    private final EIEntity diseaseEntity;
    private final EIEntity meshEntity;
    private final EIEntity locationEntity;

    public NCBIMeSHSearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        super((NCBIDBProvider)new NCBIMeSHProvider(), eagleiOntModel, registry);
        this.diseaseEntity = eagleiOntModel.getClass(EIURI.create((String)DISEASE_URI)).getEntity();
        this.meshEntity = EIEntity.create((EIURI)EIURI.create((String)"http://www.ncbi.nlm.nih.gov/mesh/"), (String)"MeSH");
        this.locationEntity = EIEntity.create((EIURI)EIURI.create((String)"http://www.ncbi.nlm.nih.gov/mesh/"), (String)"NCBI MeSH");
    }

    @Override
    public EIEntity getType() {
        return this.meshEntity;
    }

    @Override
    public boolean shouldAddResults(SearchRequest request) throws IOException {
        return true;
    }

    @Override
    protected SearchResult createSearchResultForDocSummary(ESummary.ESummaryResult sum) throws IOException {
        NCBIMeSHProvider.MeSHSummary meshSum = new NCBIMeSHProvider.MeSHSummary(sum);
        SearchResult searchResult = new SearchResult(EIEntity.create((String)meshSum.url, (String)meshSum.label), this.meshEntity, null, this.locationEntity);
        searchResult.setURL(meshSum.url);
        searchResult.setHighlight(meshSum.scopeNote.value);
        return searchResult;
    }

    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return this.getQuery(request, false, Collections.EMPTY_SET, false);
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }

    public ClassCountResult getProviderTypeCount(SearchRequest request) {
        return null;
    }
}

