/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.taxonomy;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.taxonomy.NCBITaxonomyProvider;
import org.eaglei.services.InstitutionRegistry;

public final class NCBITaxonomySearchProvider
extends NCBISearchProvider {
    private static final Log logger = LogFactory.getLog(NCBITaxonomyProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String ORGANISM_URI = "http://purl.obolibrary.org/obo/OBI_0100026";
    private final EIEntity orgEntity;
    private final EIEntity locationEntity;

    public NCBITaxonomySearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        super((NCBIDBProvider)new NCBITaxonomyProvider(), eagleiOntModel, registry);
        this.orgEntity = eagleiOntModel.getClass(EIURI.create((String)ORGANISM_URI)).getEntity();
        this.locationEntity = EIEntity.create((EIURI)EIURI.create((String)"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id="), (String)"NCBI Taxonomy");
    }

    @Override
    public EIEntity getType() {
        return this.orgEntity;
    }

    @Override
    public boolean shouldAddResults(SearchRequest request) throws IOException {
        EIURI type = NCBITaxonomySearchProvider.getType(request);
        if (type == null) {
            return false;
        }
        return this.isType(type, this.orgEntity.getURI());
    }

    @Override
    protected SearchResult createSearchResultForDocSummary(ESummary.ESummaryResult sum) throws IOException {
        NCBITaxonomyProvider.TaxonomySummary taxonomySum = new NCBITaxonomyProvider.TaxonomySummary(sum);
        SearchResult searchResult = new SearchResult(EIEntity.create((String)taxonomySum.url, (String)taxonomySum.label), this.orgEntity, null, this.locationEntity);
        searchResult.setURL(taxonomySum.url);
        searchResult.setHighlight(taxonomySum.sciName.value);
        return searchResult;
    }

    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return this.getQuery(request, true, Collections.singleton(this.orgEntity.getURI()), false);
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }

    public ClassCountResult getProviderTypeCount(SearchRequest request) {
        return null;
    }
}

