package org.eaglei.search.provider.ncbi;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eaglei.search.provider.ncbi.ESearch.ESearchResult;

/**
 * Contains logic for using NCBI eFetch.
 * 
 * @author rfrost
 */
public final class EFetch extends EUtils {

    private static final Log logger = LogFactory.getLog(EFetch.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    
    private static final String EUTILS_FETCH_URL = EUTILS_URL + "efetch.fcgi?";

    /**
     * Executes an NCBI search and then series of eFetch calls for the initial page of results.
     */
    public static ESearchResult fetch(final ESearchResult result, final String db, final String tool, final int max) throws IOException {
        if (!result.ids.isEmpty()) {
            final String fetchURL = buildServiceURL(EUTILS_FETCH_URL, result.ids, db, max, tool); 
            if (DEBUG) {
                logger.debug("Querying NCBI eFetchat " + fetchURL);
            }            
            result.details = EUtils.executeNCBIRequest(fetchURL);
            if (DEBUG) {
                logger.debug("Received details: " + EUtils.serializeDocument(result.details));
            }            
        }        
        return result;
    }    
}
