package org.eaglei.search.provider.ncbi;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.ESearch.ESearchResult;

/**
 * Abstract class that provides search support via eUtils for a specific NCBI Entrez database.
 * 
 * Requirement: no dependencies on other eagle-i classes are allowed
 *
 * @author rfrost
 */
public abstract class NCBIDBProvider {

    protected static final Log logger = LogFactory.getLog(NCBIDBProvider.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();

    /**
     * Name of tool for eagle-i that is passed to NCBI eUtils.
     */
    protected static final String EAGLEI_TOOL = "eaglei";
    
    protected final String entrezDB;

    /**
     * Creates a new NCBIDBProvider that executes queries against NCBI.
     */
    public NCBIDBProvider(final String entrezDB) {
        assert entrezDB != null;
        this.entrezDB = entrezDB;
    }
    
    public ESearchResult query(final String query, final int startIndex, final int maxResults) throws IOException {
        final ESearchResult result = ESearch.search(query, this.entrezDB, EAGLEI_TOOL, startIndex, maxResults); 
        if (!result.ids.isEmpty()) {
        	ESummary.getSummaries(result, this.entrezDB, EAGLEI_TOOL, maxResults);
        }        
        return result;
    }
}
