/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.taxonomy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.ESummary;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;

public final class NCBITaxonomyProvider
extends NCBIDBProvider {
    private static final Log logger = LogFactory.getLog(NCBITaxonomyProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String TAXONOMY = "taxonomy";
    public static final String TAXONOMY_URL = "http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=";
    public static final String NCBI_TAXONOMY_NAME = "NCBI Taxonomy";
    public static final String TAX_ID = "TaxId";
    public static final String COMMON_NAME = "CommonName";
    public static final String SCI_NAME = "ScientificName";

    public NCBITaxonomyProvider() {
        super(TAXONOMY);
    }

    public static class TaxonomySummary {
        public String id;
        public String url;
        public ESummary.Item commonName;
        public ESummary.Item sciName;
        public String label;

        public TaxonomySummary(ESummary.ESummaryResult sum) {
            this.id = sum.id;
            this.url = NCBITaxonomyProvider.TAXONOMY_URL + this.id;
            this.commonName = sum.items.get(NCBITaxonomyProvider.COMMON_NAME).get(0);
            this.sciName = sum.items.get(NCBITaxonomyProvider.SCI_NAME).get(0);
            this.label = this.commonName.value;
        }
    }
}

