/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.ESearch;
import org.eaglei.search.provider.ncbi.ESummary;

public abstract class NCBIDBProvider {
    protected static final Log logger = LogFactory.getLog(NCBIDBProvider.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    protected static final String EAGLEI_TOOL = "eaglei";
    protected final String entrezDB;

    public NCBIDBProvider(String entrezDB) {
        assert (entrezDB != null);
        this.entrezDB = entrezDB;
    }

    public ESearch.ESearchResult query(String query, int startIndex, int maxResults) throws IOException {
        ESearch.ESearchResult result = ESearch.search(query, this.entrezDB, EAGLEI_TOOL, startIndex, maxResults);
        if (!result.ids.isEmpty()) {
            ESummary.getSummaries(result, this.entrezDB, EAGLEI_TOOL, maxResults);
        }
        return result;
    }
}

