/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EUtils {
    private static final Log logger = LogFactory.getLog(EUtils.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String EUTILS_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    public static final String DB = "db=";
    public static final String TERM = "term=";
    public static final String RETMAX = "retmax=";
    public static final String RETSTART = "retstart=";
    public static final String TOOL = "tool=";
    public static final String ID_PARAM = "id=";
    public static final String RETMODE = "retmode=";
    public static final String IDLIST = "IdList";
    public static final String ID = "Id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document executeNCBIRequest(String url) throws IOException {
        HttpClient httpclient = new HttpClient();
        GetMethod httpget = new GetMethod(url);
        InputStream is = null;
        try {
            Document doc;
            httpclient.executeMethod((HttpMethod)httpget);
            is = httpget.getResponseBodyAsStream();
            Document document = doc = EUtils.parse(is);
            return document;
        }
        finally {
            httpget.releaseConnection();
            if (is != null) {
                is.close();
            }
        }
    }

    private static Document parse(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(stream));
        }
        catch (SAXException saxe) {
            throw new IOException(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
    }

    public static String buildServiceURL(String serviceURL, List<String> ids, String db, int max, String tool) {
        StringBuilder sb = new StringBuilder();
        sb.append(serviceURL);
        sb.append("&db=" + db);
        sb.append("&tool=" + tool);
        sb.append("&id=");
        for (int i = 0; i < max && i < ids.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(ids.get(i));
        }
        sb.append("&retmode=xml");
        sb.append("&retmax=" + max);
        return sb.toString();
    }

    public static String serializeDocument(Document doc) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            return writer.writeToString(doc);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

