/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderUtil;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.rdf.RepositoryConfig;

public abstract class AbstractRDFProvider
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(AbstractRDFProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    protected static final String SUBJECT = "subject";
    protected static final String PREDICATE = "predicate";
    protected static final String OBJECT = "object";
    protected static final String OBJECT_LABEL = "objectLabel";
    protected static final String OBJECT_TYPE = "objectType";
    protected final EIOntModel eagleiOntModel;
    protected List<EIURI> prefLabelProperties = new ArrayList<EIURI>();
    protected final EIEntity institution;
    protected final RepositoryConfig repoConfig;

    public AbstractRDFProvider(EIOntModel eagleiOntModel, EIEntity institution, RepositoryConfig repoConfig) {
        assert (eagleiOntModel != null);
        this.eagleiOntModel = eagleiOntModel;
        this.institution = institution;
        this.repoConfig = repoConfig;
        this.retrieveOntologyMetadata();
    }

    public void init() throws IOException {
    }

    public EIEntity getInstitution() {
        return this.institution;
    }

    private void retrieveOntologyMetadata() {
        List props = ((JenaEIOntModel)this.eagleiOntModel).getPrefLabelProperties();
        for (Property prop : props) {
            this.prefLabelProperties.add(EIURI.create((String)prop.getURI()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResultSet query(SearchRequest request) throws IOException {
        assert (request != null);
        if (request.getInstitution() != null && this.institution != null && !this.institution.getURI().equals((Object)request.getInstitution())) {
            if (DEBUG) {
                logger.debug((Object)"SearchRequest for different institution, returning empty SearchResultSet");
            }
            return new SearchResultSet(request);
        }
        String sparql = AbstractRDFProvider.createSPARQLString(request);
        if (DEBUG) {
            logger.debug((Object)("Executing query: " + sparql));
        }
        Query query = QueryFactory.create((String)sparql);
        QueryExecution qe = this.getQueryExecution(query);
        List resultList = null;
        try {
            ResultSet rs = qe.execSelect();
            resultList = ResultSetFormatter.toList((ResultSet)rs);
        }
        finally {
            qe.close();
        }
        List<SearchResult> uriToResult = this.getSearchResultsFromSPARQLResults(resultList, request);
        SearchResultSet results = this.createSearchResultSet(uriToResult, request);
        if (DEBUG) {
            logger.debug((Object)("Query executed, found " + results.getTotalCount() + " results"));
        }
        return results;
    }

    public SearchCounts count(SearchCountRequest request) throws IOException {
        return new SearchCounts(request.getRequest());
    }

    public static String createSPARQLString(SearchRequest request) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT DISTINCT");
        sparql.append(" ?subject");
        sparql.append(" ?predicate");
        sparql.append(" ?object");
        sparql.append(" WHERE { ");
        sparql.append(" ?subject");
        sparql.append(" ?predicate");
        sparql.append(" ?object.");
        EIURI type = SearchProviderUtil.getType((SearchRequest)request);
        if (type != null) {
            sparql.append(" ?subject");
            sparql.append(" <" + RDF.type.getURI() + "> ");
            sparql.append(" <" + type.toString() + ">. ");
        }
        sparql.append("}");
        return sparql.toString();
    }

    protected abstract QueryExecution getQueryExecution(Query var1);

    protected List<SearchResult> getSearchResultsFromSPARQLResults(List<QuerySolution> solns, SearchRequest request) {
        LinkedHashMap<String, Model> uriToModel = new LinkedHashMap<String, Model>();
        for (QuerySolution soln : solns) {
            Resource resource = soln.getResource(SUBJECT);
            String uri = resource.getURI();
            if (!uriToModel.containsKey(uri)) {
                uriToModel.put(uri, ModelFactory.createDefaultModel());
            }
            Model m = (Model)uriToModel.get(uri);
            Resource property = soln.getResource(PREDICATE);
            RDFNode value = soln.get(OBJECT);
            Property predicate = m.createProperty(property.getURI());
            m.add(m.createStatement(resource, predicate, value));
        }
        ArrayList<SearchResult> results = new ArrayList<SearchResult>(uriToModel.size());
        for (String uri : uriToModel.keySet()) {
            Model m;
            SearchResult result = this.createSearchResultFromModel(uri, m = (Model)uriToModel.get(uri));
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    protected SearchResult createSearchResultFromModel(String uri, Model model) {
        Resource resource = model.getResource(uri);
        EIEntity resourceEntity = EIEntity.create((EIURI)EIURI.create((String)resource.getURI()), (String)resource.getLocalName());
        Statement type = resource.getProperty(RDF.type);
        String typeURI = null;
        if (type == null) {
            Statement s;
            Property isDeleted = model.getProperty("http://eagle-i.org/ont/repo/1.0/isDeleted");
            if (isDeleted != null && (s = resource.getProperty(isDeleted)) != null && s.getObject().isLiteral() && ((Literal)s.getObject()).getBoolean()) {
                typeURI = "http://eagle-i.org/ont/repo/1.0/isDeleted";
                EIEntity typeEntity = EIEntity.create((EIURI)EIURI.create((String)typeURI), (String)typeURI);
                return new SearchResult(resourceEntity, typeEntity, null, null);
            }
        } else {
            typeURI = ((Resource)type.getObject()).getURI();
        }
        if (typeURI == null) {
            logger.error((Object)("Resource " + resource.getURI() + " is missing type"));
            return null;
        }
        EIURI typeEIURI = EIURI.create((String)typeURI);
        if (!this.eagleiOntModel.isModelClassURI(typeURI)) {
            return null;
        }
        String typeLabel = this.eagleiOntModel.getPreferredLabel(typeEIURI);
        EIEntity typeEntity = EIEntity.create((String)typeURI, (String)typeLabel);
        SearchResult result = new SearchResult(resourceEntity, typeEntity, null, this.institution);
        List statements = model.listStatements(resource, null, (RDFNode)null).toList();
        for (Statement s : statements) {
            String propertyURI = s.getPredicate().getURI();
            EIURI eiURI = EIURI.create((String)propertyURI);
            RDFNode object = s.getObject();
            if (object.isLiteral()) {
                result.addDataTypeProperty(eiURI, ((Literal)object).getLexicalForm());
                continue;
            }
            if (!object.isResource()) continue;
            Resource value = (Resource)object;
            result.addObjectProperty(eiURI, EIURI.create((String)value.getURI()));
        }
        this.setLabel(result);
        return result;
    }

    private void setLabel(SearchResult result) {
        for (EIURI prop : this.prefLabelProperties) {
            Set values = result.getDataTypeProperty(prop);
            if (values == null) continue;
            EIEntity newEntity = EIEntity.create((EIURI)result.getEntity().getURI(), (String)((String)values.iterator().next()));
            result.setEntity(newEntity);
            break;
        }
    }

    protected SearchResultSet createSearchResultSet(List<SearchResult> results, SearchRequest request) {
        int i = 0;
        int start = request.getStartIndex();
        int max = request.getMaxResults();
        SearchResultSet resultSet = new SearchResultSet(request);
        for (SearchResult result : results) {
            if (i >= start && i < start + max) {
                resultSet.getResults().add(result);
            }
            ++i;
        }
        resultSet.setStartIndex(start);
        resultSet.setTotalCount(i);
        return resultSet;
    }
}

