package org.eaglei.search.provider.rdf;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.datagen.DataGenParams;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;

/**
 * AbstractRDFProvider subclass that executes the 
 * SPARQL query against a Jena Model.
 */
public class RDFModelProvider extends AbstractRDFProvider {

    private static final Log logger = LogFactory.getLog(RDFModelProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    
    private Model model;
    
    /**
     * Creates a SearchProvider for auto-generated RDF data.
     *
     * @param genParam Generation parameters.
     * @param institution EIEntity of institution
     * 
     * @return The RDF-based SearchProvider.
     * 
     * @throws IOException Thrown if an error is encountered.
     */
    public RDFModelProvider(final EIOntModel eagleiOntModel, final DataGenParams genParams, final EIEntity institution) throws IOException {
        super(eagleiOntModel, institution, null);
        assert genParams != null;
        final RDFGenerator generator = new RDFGenerator(eagleiOntModel);
        generator.generate(genParams);
        setModel(generator.getModel());
    }

    /**
     * Creates an RDF-based repository for the specified Jena Model.
     * 
     * @param model The Jena model.
     * @param institution EIEntity of institution
     * 
     * @throws IOException Thrown if an error is encountered.
     */
    public RDFModelProvider(final Model model, final EIOntModel eagleiOntModel, final EIEntity institution) throws IOException {
        super(eagleiOntModel, institution, null);
        setModel(model);
    }
    
    private void setModel(Model model) {
        assert model != null;
        this.model = model;        
    }

    @Override
    protected QueryExecution getQueryExecution(final Query query) {
        final QueryExecution qe = QueryExecutionFactory.create(query, model);            
        return qe;
    }
}
