package org.eaglei.search.provider.rdf;

import org.eaglei.search.config.SearchProperties;

/**
 * Extension of SearchProperties that defines System properties specific to the RDF Provider.
 * 
 * Note: the property names are not actually referenced out of this file currently but specified in 
 * resources/search-rdf-config.xml and retrieved via Spring config 
 */
public final class RDFProviderProperties extends SearchProperties {
     
    /** 
     * SearchConfiguration property that holds the URL of the repository
     */
    public static final String REPOSITORY_URL = "org.eaglei.search.repository.url";
    
    /** 
     * SearchConfiguration property that holds the http basic auth username to use for calls against the repository
     */    
    public static final String REPOSITORY_USERNAME = "org.eaglei.search.repository.username";
    
    /** 
     * SearchConfiguration property that holds the http basic auth password to use for calls against the repository.
     */    
    public static final String REPOSITORY_PASSWORD = "org.eaglei.search.repository.password";   

}
