/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.rdf.AbstractRDFProvider;
import org.eaglei.services.repository.RepositoryHttpClient;

public class SPARQLProtocolProvider
extends AbstractRDFProvider {
    private static final Log logger = LogFactory.getLog(SPARQLProtocolProvider.class);

    public SPARQLProtocolProvider(EIOntModel eagleiOntModel, EIEntity institution, RepositoryHttpClient repoClient) {
        super(eagleiOntModel, institution, repoClient);
    }

    @Override
    protected SearchResult createSearchResultFromModel(String uri, Model model) {
        SearchResult result = super.createSearchResultFromModel(uri, model);
        if (result != null) {
            result.setURL(result.getEntity().toString());
        }
        return result;
    }

    @Override
    protected QueryExecution getQueryExecution(Query query) {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)this.repoClient.getSparqlUrl(), (Query)query);
        if (this.repoClient.getUsername() != null && this.repoClient.getPassword() != null) {
            qe.setBasicAuthentication(this.repoClient.getUsername(), this.repoClient.getPassword().toCharArray());
            if (this.repoClient.getDefaultGraphURI() != null) {
                qe.addDefaultGraph(this.repoClient.getDefaultGraphURI());
            }
        }
        return qe;
    }
}

