/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.rdf.RepositoryHarvester;
import org.eaglei.search.provider.rdf.SPARQLProtocolProvider;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SearchRDFConfig {
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private InstitutionRegistry institutionRegsitry;

    @Bean
    @Lazy
    public SPARQLProtocolProvider sparqlSearchProvider() {
        EIEntity institution = this.institutionRegsitry.getInstitution();
        return new SPARQLProtocolProvider(this.eagleiOntModel, institution, this.repositoryClient());
    }

    @Bean
    @Lazy
    public RepositoryHarvester harvester() {
        EIEntity institution = this.institutionRegsitry.getInstitution();
        return new RepositoryHarvester(this.eagleiOntModel, institution, this.repositoryClient());
    }

    @Bean
    @Lazy
    public RepositoryHttpClient repositoryClient() {
        if (this.institutionRegsitry.getInstitution() != null) {
            return new RepositoryHttpClient(this.institutionRegsitry.getSubdomain());
        }
        return null;
    }
}

