/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.datagen.AbstractGenerator;
import org.eaglei.search.datagen.DataGenParams;

public final class RDFGenerator
extends AbstractGenerator {
    private static final Log logger = LogFactory.getLog(RDFGenerator.class);
    public static final String UNIVERSITY_CLASS_URI = "http://purl.obolibrary.org/obo/ERO_0000065";
    private final Model model;
    private final Property directType;

    public RDFGenerator(EIOntModel eagleiOntModel) throws IOException {
        this(eagleiOntModel, ModelFactory.createDefaultModel());
    }

    public RDFGenerator(EIOntModel eagleiOntModel, Model model) throws IOException {
        super(eagleiOntModel);
        this.model = model;
        this.directType = model.createProperty("http://purl.obolibrary.org/obo/directType");
    }

    public Model getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(DataGenParams params) throws IOException {
        this.model.enterCriticalSection(false);
        try {
            super.generate(params);
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    public void closeStorage() throws IOException {
    }

    public int generateForInstitution(String uri, String label, DataGenParams genParams) throws IOException {
        Resource institution = this.model.createResource(uri);
        Statement stmt = this.model.createStatement(institution, RDF.type, (RDFNode)this.model.createResource(UNIVERSITY_CLASS_URI));
        this.model.add(stmt);
        stmt = this.model.createStatement(institution, RDFS.label, label);
        this.model.add(stmt);
        return super.generateForInstitution(uri, label, genParams);
    }

    public int generateLab(String institutionURI, String institutionLabel, String labLabel, String labURI, String labURL, String labTypeURI, DataGenParams genParams) throws IOException {
        Resource institution = this.model.getResource(institutionURI);
        Resource lab = this.model.createResource(labURI);
        OntClass labTypeClass = ((JenaEIOntModel)this.eagleiOntModel).getOntModel().getOntClass(labTypeURI);
        this.model.add(this.model.createStatement(lab, this.directType, (RDFNode)labTypeClass));
        String uri = labTypeClass.getURI();
        EIURI eiURI = EIURI.create((String)uri);
        for (EIClass type : RDFGenerator.getTypes((EIOntModel)this.eagleiOntModel, (EIURI)eiURI, (boolean)genParams.getMaterializeHierarchy())) {
            this.model.add(this.model.createStatement(lab, RDF.type, (RDFNode)this.model.getResource(type.getEntity().getURI().toString())));
        }
        this.model.add(this.model.createStatement(lab, RDFS.label, labLabel));
        this.model.add(this.model.createStatement(lab, this.model.createProperty("http://www.obofoundry.org/ro/ro.owl#located_in"), (RDFNode)institution));
        this.model.add(this.model.createStatement(institution, this.model.createProperty("http://www.obofoundry.org/ro/ro.owl#location_of"), (RDFNode)lab));
        return super.generateLab(institutionURI, institutionLabel, labLabel, labURI, labURL, labTypeURI, genParams);
    }

    public void generateResource(String institutionURI, String institutionLabel, String resourceLabel, String resourceURI, String resourceTypeURI, String resourceURL, String labName, String labURI, DataGenParams genParams) throws IOException {
        Resource institution = this.model.getResource(institutionURI);
        Resource lab = this.model.getResource(labURI);
        Resource resourceType = this.model.getResource(resourceTypeURI);
        Resource resource = this.model.createResource(resourceURI);
        this.model.add(this.model.createStatement(resource, RDFS.label, resourceLabel));
        this.model.add(this.model.createStatement(resource, this.directType, (RDFNode)resourceType));
        for (EIClass type : RDFGenerator.getTypes((EIOntModel)this.eagleiOntModel, (EIURI)EIURI.create((String)resourceTypeURI), (boolean)genParams.getMaterializeHierarchy())) {
            Statement stmt = this.model.createStatement(resource, RDF.type, (RDFNode)this.model.getResource(type.getEntity().getURI().toString()));
            this.model.add(stmt);
        }
        this.addLocatedInAndLocationOf(resource, lab);
        this.addLocatedInAndLocationOf(resource, institution);
    }

    private void addLocatedInAndLocationOf(Resource child, Resource parent) {
        Statement stmt = this.model.createStatement(child, this.model.createProperty("http://www.obofoundry.org/ro/ro.owl#located_in"), (RDFNode)parent);
        this.model.add(stmt);
        this.model.add(this.model.createStatement(parent, this.model.createProperty("http://www.obofoundry.org/ro/ro.owl#location_of"), (RDFNode)child));
    }
}

