package org.eaglei.search.provider.rdf;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SearchRDFConfig {

    private @Autowired EIOntModel eagleiOntModel;
    private @Autowired InstitutionRegistry institutionRegistry;
    
    // lazy for central search node case
    @Bean @Lazy
    public SPARQLProtocolProvider sparqlSearchProvider() {
        EIEntity institution = institutionRegistry.getInstitution();
        RepositoryHttpConfig repoConfig = institutionRegistry.getRepositoryHttpConfig(institution.getURI().toString());
        return new SPARQLProtocolProvider(eagleiOntModel, institution, repoConfig);
    }
}
