package org.eaglei.network.driver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;


import org.spin.tools.Util;


/**
 * 
 * @author Clint Gilbert
 * 
 * Feb 3, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 */
public enum Query {
    RDF,
    Count;
    
    public static final String Prefix = "Spin.Eagle-I.";
    
    public final String queryType;
    
    private Query() {
        this.queryType = makeQueryType();
    }
    
    private String makeQueryType() {
        return Prefix + this.name();
    }
    
    public static final List<String> queryTypes = makeQueryTypeList();
    
    private static List<String> makeQueryTypeList() {
        final List<String> result = Util.makeArrayList();
        
        for(final Query query : values()) {
            result.add(query.queryType);
        }
        
        return Collections.unmodifiableList(result);
    }
    
    public static Query fromQueryType(final String queryType) {
        for(final Query query : values()) {
            if(query.queryType.equals(queryType)) {
                return query;
            }
        }
        
        throw new IllegalArgumentException("Unknown query type '" + queryType + "', allowed values are " + Arrays.asList(values()));
    }
}
