/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.driver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.network.driver.EagleISpinQuerier;
import org.eaglei.network.driver.Query;
import org.eaglei.search.config.SearchConfiguration;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.MultiNodeSearchProviderFactory;

public final class EagleISpinQuerierFactory
implements MultiNodeSearchProviderFactory {
    private static final Log log = LogFactory.getLog(EagleISpinQuerierFactory.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    static final String DefaultQueryTypeToPerform = Query.RDF.name();

    public MultiNodeSearchProvider createMultiNodeSearchProvider(SearchConfiguration config) throws IOException {
        String queryType;
        String eagleISpinNodeUrl;
        if (DEBUG) {
            log.debug((Object)"Creating SPIN Network Querier");
        }
        if ((eagleISpinNodeUrl = config.getFromConfigOrSystem(Props.ProviderSpinNetworkUrlPropertyName.propKey)) == null) {
            throw new IOException("SPIN URL property " + Props.ProviderSpinNetworkUrlPropertyName.propKey + " not set");
        }
        try {
            Query queryToPerform = Query.valueOf(config.getProperties().getProperty(Props.ProviderSpinQueryTypePropertyName.propKey, DefaultQueryTypeToPerform));
            queryType = queryToPerform.queryType;
        }
        catch (Exception e) {
            throw new IOException("Unable to determine query type to perform");
        }
        return new EagleISpinQuerier(eagleISpinNodeUrl, queryType);
    }

    static enum Props {
        ProviderSpinNetworkUrlPropertyName("search.provider.spin.network.url"),
        ProviderSpinQueryTypePropertyName("search.provider.spin.query.type");

        public final String propKey;

        private Props(String propKey) {
            this.propKey = propKey;
        }
    }
}

