package org.eaglei.security;

import java.io.Serializable;

/**
 * User session representation. Includes edit permission levels.
 */
public class Session implements Serializable {

	private String	sessionId;
	private String	userName;
	private String	userURI;
	// Identifies the institution providing credentials
	// May be null in a single site app context.
	private String	institutionId;

	// TBD
	//private int permissions;

	private Session() {
		// for GWT
	}

	public static boolean isValid(Session session) {
		if (session == null)
			return false;
		else
			return (session.getSessionId() != null && session.getSessionId().length() > 0) && (session.getUserURI() != null && session.getUserURI().length() > 0);

	}

	public Session(String sessionId, String institutionId, String userName, String userURI) {
		this.sessionId = sessionId;
		this.institutionId = institutionId;
		this.userName = userName;
		this.userURI = userURI;
	}

	public String getInstitutionId() {
		return this.institutionId;
	}

	public String getUserName() {
		return this.userName;
	}

	public String getSessionId() {
		return this.sessionId;
	}

	public String getUserURI() {
		return this.userURI;
	}
}
