/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class InstitutionRegistry {
    private Map<String, String> mapURIToLabel;
    private Map<String, EIEntity> mapURIToEntity;
    private List<EIEntity> institutions;
    private EIEntity institution;

    public void setMapURIToLabel(Map<String, String> mapURIToLabel) {
        this.mapURIToLabel = mapURIToLabel;
        this.mapURIToEntity = new HashMap<String, EIEntity>();
        TreeMap<String, EIEntity> mapLabelToEntity = new TreeMap<String, EIEntity>();
        for (Map.Entry<String, String> entry : mapURIToLabel.entrySet()) {
            String uriStr = entry.getKey();
            EIURI uri = EIURI.create((String)uriStr);
            EIEntity entity = EIEntity.create((EIURI)uri, (String)entry.getValue());
            mapLabelToEntity.put(entry.getValue(), entity);
            this.mapURIToEntity.put(uriStr, entity);
        }
        this.institutions = new ArrayList(mapLabelToEntity.values());
    }

    public Map<String, String> getMapURIToLabel() {
        return this.mapURIToLabel;
    }

    public List<EIEntity> getInstitutions() {
        return this.institutions;
    }

    public void setInstitutionURI(String uri) {
        this.institution = uri == null ? null : this.mapURIToEntity.get(uri);
    }

    public String getInstitutionURI() {
        return this.institution != null ? this.institution.getURI().toString() : null;
    }

    public EIEntity getInstitution() {
        return this.institution;
    }

    public EIEntity getInstitution(String uri) {
        return this.mapURIToEntity.get(uri);
    }

    public EIEntity getInstitution(EIURI uri) {
        return this.getInstitution(uri.toString());
    }
}

