package org.eaglei.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class InstitutionRegistry {
    
    private Map<String,String> mapURIToLabel;
    private Map<String,EIEntity> mapURIToEntity;
    private List<EIEntity> institutions;
    private EIEntity institution;
    
    public InstitutionRegistry() {
    }

    public void setMapURIToLabel(Map<String,String> mapURIToLabel) {
        this.mapURIToLabel = mapURIToLabel;
        this.mapURIToEntity = new HashMap<String, EIEntity>();
        TreeMap<String, EIEntity> mapLabelToEntity = new TreeMap<String, EIEntity>();
        for (Map.Entry<String, String> entry : mapURIToLabel.entrySet()) {
            String uriStr = entry.getKey();
            EIURI uri = EIURI.create(uriStr);
            EIEntity entity = EIEntity.create(uri, entry.getValue());
            mapLabelToEntity.put(entry.getValue(), entity);
            mapURIToEntity.put(uriStr, entity);
        }
        institutions = new ArrayList<EIEntity>(mapLabelToEntity.values());
    }

    public Map<String,String> getMapURIToLabel() {
        return mapURIToLabel;
    }

    public List<EIEntity> getInstitutions() {
        return this.institutions;
    }
    
    public void setInstitutionURI(String uri) {
        if (uri == null) {
            this.institution = null;
        } else {
            this.institution = mapURIToEntity.get(uri);
        }
    }
    
    public String getInstitutionURI() {
        return (institution != null) ? institution.getURI().toString() : null;
    }
    
    public EIEntity getInstitution() {
        return this.institution;
    }
    
    public EIEntity getInstitution(String uri) {
        return mapURIToEntity.get(uri);
    }
    
    public EIEntity getInstitution(EIURI uri) {
        return getInstitution(uri.toString());
    }
    
}
