/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class InstitutionRegistry {
    private static final Log log = LogFactory.getLog(InstitutionRegistry.class);
    public static final String EAGLEI_TIER_PROPERTY = "org.eaglei.tier";
    public static final String EAGLEI_SUBDOMAIN_PROPERTY = "org.eaglei.subdomain";
    public static final String CENTRAL_SEARCH_SUBDOMAIN = "search";
    private Map<String, String> mapSubdomainToURI;
    private Map<String, String> mapURIToLabel;
    private Map<String, EIEntity> mapURIToEntity;
    private List<EIEntity> institutions;
    private String tier;
    private String subdomain;

    public void setMapSubdomainToURI(Map<String, String> mapSubdomainToURI) {
        this.mapSubdomainToURI = mapSubdomainToURI;
    }

    public Map<String, String> getMapSubdomainToURI() {
        return this.mapSubdomainToURI;
    }

    public void setMapURIToLabel(Map<String, String> mapURIToLabel) {
        this.mapURIToLabel = mapURIToLabel;
        this.mapURIToEntity = new HashMap<String, EIEntity>();
        TreeMap<String, EIEntity> mapLabelToEntity = new TreeMap<String, EIEntity>();
        for (Map.Entry<String, String> entry : mapURIToLabel.entrySet()) {
            String uriStr = entry.getKey();
            EIURI uri = EIURI.create((String)uriStr);
            EIEntity entity = EIEntity.create((EIURI)uri, (String)entry.getValue());
            mapLabelToEntity.put(entry.getValue(), entity);
            this.mapURIToEntity.put(uriStr, entity);
        }
        this.institutions = new ArrayList(mapLabelToEntity.values());
    }

    public Map<String, String> getMapURIToLabel() {
        return this.mapURIToLabel;
    }

    public List<EIEntity> getInstitutions() {
        return this.institutions;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public EIEntity getInstitution() {
        if (this.subdomain == null) {
            return null;
        }
        return this.mapURIToEntity.get(this.mapSubdomainToURI.get(this.subdomain));
    }

    public EIEntity getInstitution(String uri) {
        return this.mapURIToEntity.get(uri);
    }

    public EIEntity getInstitution(EIURI uri) {
        return this.getInstitution(uri.toString());
    }
}

