/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

public final class RepositoryHttpClient {
    public static final String EAGLEI_REPOSITORY_USERNAME_PROPERTY = "org.eaglei.repository.username";
    public static final String EAGLEI_REPOSITORY_PASSWORD_PROPERTY = "org.eaglei.repository.password";
    public static final String PUBLISHED_NG = "http://eagle-i.org/ont/repo/1.0/NG_Published";
    public static final String DEFAULT_NG = "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace";
    private String username = null;
    private String password = null;
    private String defaultGraphURI = "http://eagle-i.org/ont/repo/1.0/NG_Published";
    private String view = "published-resources";
    private String whoamiUrl;
    private String logoutUrl;
    private String sparqlUrl;
    private String harvestUrl;

    public RepositoryHttpClient(String institutionSubdomain) {
        this(institutionSubdomain, System.getProperty(EAGLEI_REPOSITORY_USERNAME_PROPERTY), System.getProperty(EAGLEI_REPOSITORY_PASSWORD_PROPERTY));
    }

    public RepositoryHttpClient(String institutionSubdomain, String username, String password) {
        assert (institutionSubdomain != null);
        String tier = System.getProperty("org.eaglei.tier");
        String baseUrl = this.computeBaseUrl(tier, institutionSubdomain);
        this.whoamiUrl = baseUrl + "whoami";
        this.logoutUrl = baseUrl + "logout/";
        this.sparqlUrl = baseUrl + "sparql";
        this.harvestUrl = baseUrl + "harvest";
        this.setUsername(username);
        this.setPassword(password);
    }

    private String computeBaseUrl(String tier, String institutionSubdomain) {
        StringBuilder buf = new StringBuilder();
        buf.append("https://");
        if (tier != null && !tier.toLowerCase().equals("prod")) {
            buf.append(tier.toLowerCase());
            buf.append('.');
        }
        buf.append(institutionSubdomain.toLowerCase());
        buf.append(".eagle-i.net/repository/");
        return buf.toString();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public void setDefaultGraphURI(String defaultGraphURI) {
        this.defaultGraphURI = defaultGraphURI;
    }

    public String getDefaultGraphURI() {
        return this.defaultGraphURI;
    }

    public String getWhoamiUrl() {
        return this.whoamiUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getHarvestUrl() {
        return this.harvestUrl;
    }

    public String getSparqlUrl() {
        return this.sparqlUrl;
    }
}

