/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.services.repository.RepositoryProviderException;

public class ProviderUtils {
    private static final Log logger = LogFactory.getLog(ProviderUtils.class);

    public static String getStringFromInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    public static String getHttpResponse(HttpClient client, HttpMethod method) throws RepositoryProviderException {
        String responseBody;
        int status = 0;
        if (client == null) {
            logger.warn((Object)"trying to get response with null client");
            throw new RepositoryProviderException("trying to get response with null client", RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
        }
        String originalPath = null;
        try {
            originalPath = method.getURI().toString();
        }
        catch (URIException e2) {
            logger.error((Object)e2);
        }
        try {
            status = client.executeMethod(method);
            responseBody = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
        }
        catch (HttpException e) {
            throw new RepositoryProviderException(e);
        }
        catch (IOException e1) {
            throw new RepositoryProviderException(e1);
        }
        finally {
            method.releaseConnection();
        }
        if (status == 200 || status == 201) {
            logger.info((Object)("Request succeded with status: " + status));
            return responseBody;
        }
        RepositoryProviderException.RepositoryProviderExceptionType type = RepositoryProviderException.RepositoryProviderExceptionType.getTypeFromStatus(status);
        if (type != null) {
            if (type == RepositoryProviderException.RepositoryProviderExceptionType.MOVED_PERMANENTLY || type == RepositoryProviderException.RepositoryProviderExceptionType.MOVED_TEMPORARILY) {
                StringBuilder strBuild = new StringBuilder();
                strBuild.append(type == RepositoryProviderException.RepositoryProviderExceptionType.MOVED_TEMPORARILY ? "Temporary" : "Permanent");
                strBuild.append(" redirect encountered for url: '");
                strBuild.append(originalPath);
                strBuild.append("' should be: '");
                strBuild.append(method.getResponseHeader("Location").getValue());
                strBuild.append("'");
                logger.warn((Object)strBuild.toString());
            }
            logger.error((Object)type.getMessage());
            throw new RepositoryProviderException(type);
        }
        String message = "Operation failed with status: " + status + " response: " + responseBody;
        logger.error((Object)message);
        throw new RepositoryProviderException(message);
    }
}

