package org.eaglei.services.repository;

import java.util.HashMap;
import java.util.List;

import org.apache.commons.httpclient.HttpClient;
import org.eaglei.model.EIEntity;
import org.eaglei.security.Session;


public interface SecurityProvider {

	public Session logIn(String institutionId, String username, String password) throws RepositoryProviderException;
    public void logOut(String sessionId)throws RepositoryProviderException;
    public Session getSession(String sessionId);
    public boolean isValid(String sessionId, boolean shouldThrow) throws RepositoryProviderException;
    public HttpClient getHttpClient(Session session);
    public List<HashMap<String, String>> getWorkspaces(String institutionId, String sessionId) throws RepositoryProviderException;
    public boolean isOnline(String institutionId);
    public Session whoami(final String sessionId) throws RepositoryProviderException;
    public List<HashMap<String, EIEntity>> listWorkFlowTransitions(String institutionId, final String sessionId, final EIEntity workspaceEntity) throws RepositoryProviderException;
}
