package org.eaglei.services;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class NodeConfig {

    private String nodeId;
    private String label;
    private String uri;
    private String repositoryHostUrl;
    private String searchUsername;
    private String searchPassword;
    
    private EIEntity entity;
    
    public NodeConfig() {
    }
    
    public String getNodeId() {
        return nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public EIEntity getEntity() {
        if (entity == null) {
            assert(getUri() != null && getLabel() != null);
            EIURI uri = EIURI.create(getUri());
            entity = EIEntity.create(uri, getLabel());
        }
        return entity;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getRepositoryHostUrl() {
        return repositoryHostUrl;
    }

    public void setRepositoryHostUrl(String repositoryHostUrl) {
        this.repositoryHostUrl = repositoryHostUrl;
    }
    
    public String getSearchUsername() {
        return searchUsername;
    }

    public void setSearchUsername(String searchUsername) {
        this.searchUsername = searchUsername;
    }

    public String getSearchPassword() {
        return searchPassword;
    }

    public void setSearchPassword(String searchPassword) {
        this.searchPassword = searchPassword;
    }

}
