package org.eaglei.services.repository;

import java.io.Serializable;

public class RepositoryProviderException extends Exception implements Serializable {
	
	private RepositoryProviderExceptionType type;

	/**
	 * 
	 */
	private static final long serialVersionUID = 1557653921270297044L;

	public RepositoryProviderException() {
		this(null, null, RepositoryProviderExceptionType.GENERAL);
	}
	
	public RepositoryProviderException(RepositoryProviderExceptionType type) {
		this(null, null, type);
	}

	public RepositoryProviderException(final String message) {
		this(message, null, RepositoryProviderExceptionType.GENERAL);
	}
	
	public RepositoryProviderException(final String message, RepositoryProviderExceptionType type) {
		this(message, null, type);
	}

	public RepositoryProviderException(final Throwable cause) {
		this(null, cause, RepositoryProviderExceptionType.GENERAL);
	}
	
	public RepositoryProviderException(final Throwable cause, RepositoryProviderExceptionType type) {
		this(null, cause, type);
	}

	public RepositoryProviderException(final String message, final Throwable cause) {
		this(message, cause, RepositoryProviderExceptionType.GENERAL);
	}
	
	public RepositoryProviderException(final String message, final Throwable cause, RepositoryProviderExceptionType type) {
		super( message, cause );
		if (type == null) {
			this.type = RepositoryProviderExceptionType.GENERAL;
		}
		else {
			this.type = type;
		}
	}
	
	@Override
	public String getMessage() {
		if (super.getMessage() == null) {
			return type.getMessage();
		}
		else {
			return super.getMessage();
		}
	}
	
	public RepositoryProviderExceptionType getExceptionType() {
		return type;
	}
	
	public static enum RepositoryProviderExceptionType {
		
		//301 = MOVED PERMANENTLY
		MOVED_PERMANENTLY("Permanent Redirect.", 301),
		//302 = MOVED TEMPORARILY
		MOVED_TEMPORARILY("Temporary Redirect.", 302),
		//404 = HttpStatus.SC_NOT_FOUND
		NOT_FOUND("Repository unavailable.", 404),
		//401 = HttpStatus.SC_UNAUTHORIZED
		UNAUTHORIZED("Not authorized to get user information (login/whoami).", 401), 
		//409 = HttpStatus.SC_CONFLICT
		CONFLICT("Probably a stale token.", 409), 
		//500 =  HttpStatus.SC_INTERNAL_SERVER_ERROR
		INTERNAL_SERVER_ERROR("Repository internal server error", 500), 
		//400 =  HttpStatus.SC_BAD_REQUEST
		BAD_REQUEST("Bad request.", 400),
		//406 = HttpStatus.SC_NOT_ACCEPTABLE
		NOT_ACCEPTABLE("Not acceptable request.", 406), 
		//403 = HttpStatus.SC_FORBIDDEN
		FORBIDDEN("Repository operation not permitted.", 403),
		//410 = HttpStatus.SC_GONE
		GONE("Repository resource is temporarily unavailable.", 410),
		//No http error code associated
		GENERAL("General Failure.", 0),
		//No http error code associated
		INVALID_SESSION("Session is invalid.", 0);
		
		private final String message;
		private final int status;
		
		private RepositoryProviderExceptionType(String message, int httpStatus) {
			this.message = message;
			status = httpStatus;
		}
		
		public String getMessage() {
			return message;
		}
		
		public int getHttpStatus() {
			return status;
		}
		
		public static RepositoryProviderExceptionType getTypeFromStatus(int status) {
			RepositoryProviderExceptionType result = null;
			RepositoryProviderExceptionType[] values = RepositoryProviderExceptionType.values();
			for (int i=0; i < values.length && result == null; i++){
				if (values[i].getHttpStatus() == status) {
					result = values[i];
				}
			}
			return result;
		}
	}

}
