/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.services.NodeConfig;

public final class RepositoryHttpConfig {
    public static final String EAGLEI_REPOSITORY_USERNAME_PROPERTY = "org.eaglei.repository.username";
    public static final String EAGLEI_REPOSITORY_PASSWORD_PROPERTY = "org.eaglei.repository.password";
    public static final String PUBLISHED_NG = "http://eagle-i.org/ont/repo/1.0/NG_Published";
    public static final String DEFAULT_NG = "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace";
    public static final String PUBLISHED_VIEW = "published-resources";
    private static final Log log = LogFactory.getLog(RepositoryHttpConfig.class);
    private final String hostURL;
    private final String baseURL;
    private String searchUsername;
    private String searchPassword;

    public RepositoryHttpConfig(NodeConfig nodeConfig, String tier) {
        this(RepositoryHttpConfig.computeHostURL(tier, nodeConfig.getRepositoryHostUrl()));
        this.setSearchUsername(nodeConfig.getSearchUsername());
        this.setSearchPassword(nodeConfig.getSearchPassword());
    }

    public RepositoryHttpConfig(String hostURL) {
        if (hostURL == null) {
            throw new RuntimeException("URL may not be null.");
        }
        this.hostURL = hostURL;
        this.baseURL = hostURL + "repository/";
    }

    public String getHostURL() {
        return this.hostURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public static HttpClient createHttpClient(String username, String password) {
        HttpClient client = new HttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    public static String computeHostURL(String tier, String repositoryHostUrl) {
        if (repositoryHostUrl == null) {
            return "localhost/";
        }
        StringBuilder buf = new StringBuilder();
        String domainOnly = repositoryHostUrl.startsWith("https://") ? repositoryHostUrl.substring("https://".length()) : (repositoryHostUrl.startsWith("http://") ? repositoryHostUrl.substring("http://".length()) : repositoryHostUrl);
        buf.append("https://");
        if (tier != null) {
            buf.append(tier.toLowerCase());
            buf.append('.');
        }
        buf.append(domainOnly);
        return buf.toString();
    }

    public String getFullRepositoryUrl(RepositoryLocale locale) {
        if (locale != RepositoryLocale.SEARCH_INSTANCE_URL) {
            return this.baseURL + locale.getURL();
        }
        return this.hostURL + locale.getURL();
    }

    public String getSearchUsername() {
        return this.searchUsername;
    }

    public void setSearchUsername(String searchUsername) {
        this.searchUsername = searchUsername;
    }

    public String getSearchPassword() {
        return this.searchPassword;
    }

    public void setSearchPassword(String searchPassword) {
        this.searchPassword = searchPassword;
    }

    public static enum RepositoryLocale {
        WHOAMI_URL("whoami"),
        LOGOUT_URL("logout/"),
        SPARQL_URL("sparql"),
        HARVEST_URL("harvest"),
        SEARCH_INSTANCE_URL("i"),
        CONTACT_URL("emailContact"),
        NEW_INSTANCE_URL("new"),
        UPDATE_INSTANCE_URL("update"),
        GET_INSTANCE_URL("resource"),
        GRAPH_URL("graph"),
        FAKE_WORKFLOW_URL("fakeworkflow"),
        LIST_GRAPHS_URL("listGraphs"),
        CLAIM_URL("workflow/claim"),
        RELEASE_URL("workflow/release"),
        TRANSITION_URL("workflow/push"),
        LIST_TRANSITIONS_URL("workflow/transitions"),
        LIST_RESOURCES_URL("workflow/resources");

        private String url;

        private RepositoryLocale(String url) {
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }
    }
}

