package org.eaglei.services.repository;

import org.eaglei.model.EIOntModel;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

/**
 * A Spring java-based config file for creating a
 * repository-backed SecurityProvider bean.
 * 
 */
@Configuration
@ImportResource("classpath:services-config.xml")
public class RepositoryConfig {

    @Autowired
    private InstitutionRegistry registry;     

    @Autowired
    private EIOntModel eagleiOntModel;
    
    @Bean
    public SecurityProvider securityProvider() {
        return new RepositorySecurityProvider(registry);
    }
    
    @Bean
    public RepositoryInstanceProvider instanceProvider() {
    	return new RepositoryInstanceProvider(eagleiOntModel, (RepositorySecurityProvider)securityProvider(), registry);
    }
}
