package org.eaglei.solr.search;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.CountResult;

public class ClassUsage implements Serializable, Comparable<ClassUsage> {
	
	private CountResult totalCount;	
	private HashSet<EIURI> setSubClassUsage = new HashSet<EIURI>();
	
	private ClassUsage() {
		// for gwt
	}
	
	public ClassUsage(EIEntity entity) {
		totalCount = new CountResult(entity);
	}
	
	public EIEntity getEntity() {
		return totalCount.getEntity();
	}
	
	public void incrementUsage() {
		totalCount.increment();
	}
	
	public void decrementUsage() {
		totalCount.decrement();
	}
	
	public CountResult getTotalCount() {
		return totalCount;
	}
	
	public void addSubClassUsage(EIURI subclassURI) {
		setSubClassUsage.add(subclassURI);
	}
	
	public void removeSubClassUsage(EIURI subclassURI) {
		setSubClassUsage.remove(subclassURI);
	}
	
	public Set<EIURI> getSubClassUsages() {
		return setSubClassUsage;
	}
	
    @Override
    public boolean equals(Object o) {
    	if (o instanceof ClassUsage) {
        	return totalCount.equals(((ClassUsage) o).totalCount);
    	}
    	return false;
    }
    
    @Override
    public int hashCode() {
        return totalCount.getEntity().hashCode();
    }
    
    @Override
    public int compareTo(ClassUsage o) {
    	// putting o.count first makes higher count appear first
        int result = o.totalCount.getCount().compareTo(totalCount.getCount());
        if (result == 0) {
            result = totalCount.getEntity().compareTo(o.totalCount.getEntity());
        }
        return result;
    }
    
    @Override
    public String toString() {
        return totalCount.getEntity().toString() + "  (" + totalCount.getCount() + ")";
    }

}
