package org.eaglei.solr.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;

import com.hp.hpl.jena.vocabulary.RDF;

public class ProviderUsageCache {

    private static final Log logger = LogFactory.getLog(ProviderUsageCache.class);
    
    private final EIOntModel eiOntModel;
    private final HashMap<EIEntity, ClassUsage> mapProviderTypeEntityToUsage = new HashMap<EIEntity, ClassUsage>();

    
    public ProviderUsageCache(EIOntModel eiOntModel) {
    	this.eiOntModel = eiOntModel;
    	/*
    	List<EIClass> listDataModelCreateResources = eiOntModel.getClassesInGroup(EIOntConstants.CG_DATA_MODEL_CREATE);
    	this.listPrimaryResources = new ArrayList<EIEntity>(listDataModelCreateResources.size() + 1);
    	for (EIClass c : listDataModelCreateResources) {
        	listPrimaryResources.add(c.getEntity());
    	}
    	EIClass coreResource = eiOntModel.getClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000002"));
    	listPrimaryResources.add(coreResource.getEntity());
    	*/
    }
    
    /*
     * Remove usage count.
     */
    void removeUsage(String providerTypeURIStr) {
    	EIClass providerClass = eiOntModel.getClass(EIURI.create(providerTypeURIStr));
    	if (providerClass == null) {
    		logger.warn("removeUsage: Unrecognized type for provider: " + providerTypeURIStr);
    		return;
    	}
    	removeUsage(providerClass.getEntity());
    }

    /*
     * Remove usage count.
     */
    void removeUsage(EIEntity providerTypeEntity) {
    	ClassUsage providerUsage = mapProviderTypeEntityToUsage.get(providerTypeEntity);
    	assert(providerUsage != null) : "removeUsage called for a type that had no usage previously recorded: " + providerTypeEntity;
    	providerUsage.decrementUsage();  
    	if (providerUsage.getTotalCount().getCount() == 0) {
    		mapProviderTypeEntityToUsage.remove(providerTypeEntity);
    	}
    }

    /*
     * Add usage count.
     */
    void addUsage(String providerTypeURIStr) {
    	EIClass providerClass = eiOntModel.getClass(EIURI.create(providerTypeURIStr));
    	if (providerClass == null) {
    		logger.warn("addUsage: Unrecognized type for provider: " + providerTypeURIStr);
    		return;
    	}
    	addUsage(providerClass.getEntity());
    }
    
    /*
     * Add usage count.
     */
    void addUsage(EIEntity providerTypeEntity) {
    	ClassUsage providerUsage = mapProviderTypeEntityToUsage.get(providerTypeEntity);
    	if (providerUsage == null) {
    		providerUsage = new ClassUsage(providerTypeEntity);
    		mapProviderTypeEntityToUsage.put(providerTypeEntity, providerUsage);
    	}
    	providerUsage.incrementUsage();   
    }
    
    public ClassCountResult getProviderCount(SearchRequest request) {    	    
    	ClassCountResult result;
		// Null entity indicates the All count
    	// TODO: unused, shouldn't be required
        CountResult providerTotalCount = new CountResult(null, 0);
        // Compute the root class set result      
		SortedSet<CountResult> providerTypes = new TreeSet<CountResult>();
		for (ClassUsage providerUsage : mapProviderTypeEntityToUsage.values()) {
            providerTypes.add(providerUsage.getTotalCount());
            providerTotalCount.increment(providerUsage.getTotalCount().getCount());
        }    	
		result = new ClassCountResult(request);
		result.setClassCount(providerTotalCount);
		result.setSubClassCounts(providerTypes);
	    
	    return result;
    }
    
}
