/**
 * 
 */
package org.eaglei.solr.search;

import java.util.HashSet;
import java.util.Set;

import org.eaglei.services.InstitutionRegistry;

public class SearchExcludeConfiguration {
	private static final String DOMAIN_PREFIX = "http://";
	
    private Set<String> excludedProviderURIs;

	public Set<String> getExcludedProviderURIs() {
		return excludedProviderURIs;
	}

	public void setExcludedProviderURIs(Set<String> excludedProviderURIs) {
		this.excludedProviderURIs = excludedProviderURIs;
	}

	/**
	 * Injects the tier string as a domain qualifier in all exclude URIs.
	 * 
	 * @param tier
	 */
	public void setTier(String tier) {
		if (excludedProviderURIs == null) {
			return;
		}
		if (tier == null || InstitutionRegistry.PRODUCTION_TIER.equals(tier)) {
			return;
		}
		Set<String> updatedExcludedProviderURIs = new HashSet<String>(excludedProviderURIs.size());
		for (String uri : excludedProviderURIs) {
			String tierURI = DOMAIN_PREFIX + tier + "." + uri.substring(DOMAIN_PREFIX.length());
			updatedExcludedProviderURIs.add(tierURI);
			this.excludedProviderURIs = updatedExcludedProviderURIs;
		}
	}
}