/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SearchSuggestOracle;
import org.eaglei.suggest.client.SearchSuggestion;
import org.eaglei.suggest.client.SelectionListener;

public class SharedClassChooser<OntologyPicker extends OntologyDropdownBase>
extends Composite {
    private TypeSuggestBox boxType;
    private OntologyPicker ontologyBrowser;

    public SharedClassChooser(OntologyPicker ontPicker) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget((Widget)hp);
        this.boxType = new TypeSuggestBox();
        this.boxType.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                SearchSuggestion suggestion = (SearchSuggestion)event.getSelectedItem();
                EIEntity selectedEntity = EIEntity.create((String)suggestion.getURIString(), (String)SharedClassChooser.this.removeTags(suggestion.getDisplayString()));
                SharedClassChooser.this.boxType.setSelectedEntity(selectedEntity);
            }
        });
        hp.add((Widget)this.boxType);
        this.ontologyBrowser = ontPicker;
        ((OntologyDropdownBase)((Object)this.ontologyBrowser)).addSelectionListener(new SelectionListener(){

            @Override
            public void onSelection(EIClass resource) {
                SharedClassChooser.this.boxType.setSelectedEntity(resource.getEntity());
            }
        });
        hp.add(this.ontologyBrowser);
    }

    public void addSelectionListener(EntitySelectionListener listener) {
        this.boxType.addSelectionListener(listener);
    }

    protected String removeTags(String displayString) {
        String result = displayString.replace("<B>", "");
        result = result.replace("</B>", "");
        return result;
    }

    public void setClass(EIClass rClass, boolean readOnly) {
        this.boxType.setResource(rClass);
        this.ontologyBrowser.setVisible(true);
        if (rClass.hasSubClass()) {
            ((OntologyDropdownBase)((Object)this.ontologyBrowser)).setResource(rClass);
        } else {
            ((OntologyDropdownBase)((Object)this.ontologyBrowser)).setResource(null);
        }
    }

    public EIURI getSelectedURI() {
        return this.boxType.getSelectedEntity().getURI();
    }

    public String getSelectedLabel() {
        return this.boxType.getSelectedEntity().getLabel();
    }

    public EIEntity getSelectedEntity() {
        return this.boxType.getSelectedEntity();
    }

    public void setSelectedEntity(EIEntity selectedEntity) {
        this.boxType.setSelectedEntity(selectedEntity);
    }

    public void setTextBoxStyle(String styleName) {
        this.boxType.setStyleName(styleName);
    }

    public void setEnabled(boolean enabled) {
        this.boxType.setEnabled(enabled);
        this.ontologyBrowser.setVisible(enabled);
    }

    private static class TypeSuggestBox
    extends AbstractSearchBox {
        private EIClass resource;
        private EIEntity selectedEntity;
        private ArrayList<EntitySelectionListener> listeners = null;

        public TypeSuggestBox() {
            super(new TypeSuggestOracle(), "TypeSearchBox");
            this.sbSearch.getTextBox().addBlurHandler(new BlurHandler(){

                public void onBlur(BlurEvent event) {
                    if (!TypeSuggestBox.this.selectedEntity.getLabel().equals(TypeSuggestBox.this.sbSearch.getText())) {
                        if (TypeSuggestBox.this.selectedEntity.equals((Object)TypeSuggestBox.this.resource.getEntity())) {
                            TypeSuggestBox.this.setDefaultText();
                        } else {
                            TypeSuggestBox.this.sbSearch.setText(TypeSuggestBox.this.selectedEntity.getLabel());
                        }
                    }
                }
            });
        }

        public void setEnabled(boolean enabled) {
            this.sbSearch.getTextBox().setEnabled(enabled);
        }

        public void addSelectionListener(EntitySelectionListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }

        @Override
        public String getDefaultText() {
            return this.resource != null ? this.resource.getEntity().getLabel() : "";
        }

        @Override
        public String getSearchBaseURL() {
            assert (false);
            return null;
        }

        public void setResource(EIClass resource) {
            this.resource = resource;
            this.selectedEntity = resource.getEntity();
            ((TypeSuggestOracle)this.sbSearch.getSuggestOracle()).setClassId(resource.getEntity().getURI());
            this.setDefaultText();
        }

        public EIEntity getSelectedEntity() {
            return this.selectedEntity;
        }

        public void setSelectedEntity(EIEntity selectedEntity) {
            this.selectedEntity = selectedEntity;
            this.setText(selectedEntity.getLabel());
            if (this.listeners != null) {
                for (EntitySelectionListener listener : this.listeners) {
                    listener.onSelection(selectedEntity);
                }
            }
        }
    }

    private static class TypeSuggestOracle
    extends SearchSuggestOracle {
        private String classId;

        public TypeSuggestOracle() {
            super(GWT.getModuleBaseURL());
        }

        void setClassId(EIURI classId) {
            this.classId = URL.encodeComponent((String)classId.toString());
        }

        @Override
        protected String createURL(String callbackName, int id, String query) {
            String url = super.createURL(callbackName, id, query);
            return url + "&classid=" + this.classId;
        }
    }
}

