/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.ui.SuggestOracle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eaglei.suggest.client.SearchSuggestion;

public class SearchSuggestOracle
extends SuggestOracle {
    private HashMap<Integer, SuggestCallback> callbacks = new HashMap();
    private int curIndex = 0;
    private final String urlSuggestServlet;
    private ArrayList<SearchSuggestion> curSuggestionList = null;

    public SearchSuggestOracle(String baseURL) {
        this.urlSuggestServlet = baseURL + "suggest";
    }

    public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        while (true) {
            if (this.curIndex == Integer.MAX_VALUE) {
                this.curIndex = 0;
            }
            if (!this.callbacks.containsKey(new Integer(this.curIndex))) {
                SuggestCallback serverCallback = new SuggestCallback();
                serverCallback.callback = callback;
                serverCallback.req = request;
                this.callbacks.put(new Integer(this.curIndex), serverCallback);
                String callbackName = "__search_suggest_callback" + this.curIndex;
                SearchSuggestOracle.setup(this, callbackName);
                String url = this.createURL(callbackName, this.curIndex, request.getQuery());
                serverCallback.scriptTag = this.addScript(callbackName, url);
                ++this.curIndex;
                return;
            }
            ++this.curIndex;
        }
    }

    public boolean isDisplayStringHTML() {
        return true;
    }

    public void handle(JavaScriptObject jso) {
        JSONObject jsonObj = new JSONObject(jso);
        try {
            Integer id;
            String strID = jsonObj.get("id").isString().stringValue();
            try {
                id = Integer.parseInt(strID);
            }
            catch (NumberFormatException ex) {
                System.out.println("ERROR: callback id not an integer: " + strID);
                System.out.println(jsonObj.toString());
                return;
            }
            SuggestCallback serverCallback = this.callbacks.remove(id);
            if (serverCallback == null) {
                System.out.println("ERROR: unrecognized suggest callback id: " + id);
                System.out.println(jsonObj.toString());
                return;
            }
            this.removeScript(serverCallback.scriptTag);
            SuggestOracle.Response response = new SuggestOracle.Response();
            JSONArray jsonSuggestionArray = jsonObj.get("suggestions").isArray();
            ArrayList<SearchSuggestion> listSuggestion = new ArrayList<SearchSuggestion>();
            if (jsonSuggestionArray != null) {
                int i = 0;
                while (i < jsonSuggestionArray.size()) {
                    String displayString = jsonSuggestionArray.get(i++).isString().stringValue();
                    String replacementString = jsonSuggestionArray.get(i++).isString().stringValue();
                    String uriString = jsonSuggestionArray.get(i++).isString().stringValue();
                    SearchSuggestion suggestion = new SearchSuggestion(displayString, replacementString, uriString);
                    listSuggestion.add(suggestion);
                }
            }
            response.setSuggestions(listSuggestion);
            serverCallback.callback.onSuggestionsReady(serverCallback.req, response);
            this.curSuggestionList = listSuggestion;
        }
        catch (NullPointerException ex) {
            System.out.println("ERROR: NPE probably caused by unexpected JSON response format");
            System.out.println(jsonObj.toString());
            ex.printStackTrace();
        }
    }

    public List<SearchSuggestion> getCurrentSuggestionList() {
        return this.curSuggestionList;
    }

    protected String createURL(String callbackName, int id, String query) {
        String encode = URL.encodeComponent((String)query);
        return this.urlSuggestServlet + "?callback=" + callbackName + "&id=" + id + "&q=\"" + encode + "\"";
    }

    public native Element addScript(String var1, String var2);

    public native void removeScript(Element var1);

    public static native void setup(SearchSuggestOracle var0, String var1);

    private static class SuggestCallback {
        Element scriptTag;
        SuggestOracle.Request req;
        SuggestOracle.Callback callback;

        private SuggestCallback() {
        }
    }
}

