package org.eaglei.suggest.client;

import org.eaglei.model.EIEntity;

import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;

/**
 * @author tbashor
 */
public class SearchSuggestion implements Suggestion {
    private String displayString;
    private String replacementString;
    private String uriString;
    
    public SearchSuggestion(String displayString, String replacementString, String uriString) {
        this.displayString = displayString;
        this.replacementString = replacementString;
        this.uriString = uriString;
    }

    public String getURIString() {
        return uriString;
    }

    public String getDisplayString() {
        return displayString;
    }

    public String getReplacementString() {
        return replacementString;
    }
    
    public EIEntity createEntity() {
    	return EIEntity.create(getURIString(), getReplacementString());
    }
}
