package org.eaglei.ui.gwt.search.results;

import java.util.Set;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ResourcesGrid extends FlexTable {
    
    private static class CellPanel extends VerticalPanel {
        
        CellPanel() {
            setStyleName("resultsTableCell");
            setSpacing(0);
        }
        
        void setContent(Widget primary, Widget secondary) {
            clear();
            add(primary);
            primary.addStyleName("primary");
            if (secondary != null) {
                add(secondary);
                secondary.setStyleName("secondary");
            }
        }
    }
    
    private static final int PAGE_SIZE = SearchRequest.DEFAULT_PAGE_SIZE;
    private static final int NAV_BAR_ROW = 0;
    private static final int HEADER_ROW = 1;
    private static final int STATUS_ROW = 2;
    private static final int PROGRESS_ROW = 3;
    private static final int FIRST_RESULT_ROW = 4;
    
	public static final String	RESOURCE_COLUMN_NAMES[]	= { "Resource Name", "Type", "Location" };
	private ClientSearchResultSet currentResults;
	private NavBar navBar;
	private Label status;
	
	public ResourcesGrid() {
        // Header columns
        setStyleName("listGrid");
        navBar = new NavBar(this);
        setWidget(NAV_BAR_ROW, 0, navBar);
        int col = 0;
        for (String colName : RESOURCE_COLUMN_NAMES) {
            getCellFormatter().setStyleName(HEADER_ROW, col, "listGridHeader");
            setHTML(HEADER_ROW, col++, "<b>" + colName + "</b>");
        }
        status = new Label();
        setWidget(STATUS_ROW, 0, status);
        setWidget(PROGRESS_ROW, 0, new Image(ApplicationResources.INSTANCE.loading()));
	}
	
	public void displaySearchPending() {
        currentResults = null;
        RowFormatter rf = getRowFormatter();
        rf.setVisible(NAV_BAR_ROW, false);
        rf.setVisible(STATUS_ROW, false);
        rf.setVisible(PROGRESS_ROW, true);
	    for (int i = getRowCount()-1; i>=FIRST_RESULT_ROW; i--) {
	        removeRow(i);
	    }
	}
	
	
	public void displaySearchResults(ClientSearchResultSet results) {
        RowFormatter rf = getRowFormatter();
        
	    currentResults = results;
        rf.setVisible(PROGRESS_ROW, false);

        // Update the nav bar.
        int count = results.getResultSet().getTotalCount();
        int max = results.getResultSet().getStartIndex() + PAGE_SIZE;
        if (max > count) {
            max = count;
        }
        navBar.update(results.getResultSet().getStartIndex(), count, max);
        rf.setVisible(NAV_BAR_ROW, true);
        
        // Add the results
        if (results.getResultSet().getResults().size() == 0) {
            status.setText("No results found.");
            rf.setVisible(STATUS_ROW, true);
        } else {
            rf.setVisible(STATUS_ROW, false);
            int row = FIRST_RESULT_ROW;
            for (SearchResult result : results.getResultSet().getResults()) {
                createInstanceRow(row++, result);
            }
        }
        
	}
	
	public void createInstanceRow(int row, SearchResult searchResult) {
		int col = 0;
		
		// Name cell
        Anchor instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
        instanceLink.setTarget("_blank"); // display in new tab
        HTML snippit = null;
        if (searchResult.getHighlight() != null) {
            snippit = new HTML(searchResult.getHighlight());
        }
        CellPanel cp = new CellPanel();
        cp.setContent(instanceLink, snippit);
        setWidget(row, col++, cp);

        // Type cell
        Label typeLabel = new Label(searchResult.getType().getLabel());
        Label rootTypeLabel = null;
        EIEntity rootTypeEntity = currentResults.getMapURIToRootEntity().get(searchResult.getType().getURI());
        if (rootTypeEntity != null) {
            rootTypeLabel = new Label(rootTypeEntity.getLabel());
        }
        cp = new CellPanel();
        cp.setContent(typeLabel, rootTypeLabel);
        if (rootTypeLabel != null) {
            rootTypeLabel.addStyleName("rootType");
        }
        setWidget(row, col++, cp);
		
        // Location cell
		EIEntity lab = searchResult.getLab();
		Anchor labLink;
		if (lab != null) {
		    labLink = new Anchor(lab.getLabel(), lab.getURI().toString());
		    labLink.setTarget("_blank"); // display in new tab
		} else {
		    labLink = null;
		}
        Label instLabel = new Label(searchResult.getInstitution().getLabel());
        cp = new CellPanel();
		if (ApplicationContext.IS_INSTITUTION) {
		    if (labLink != null) {
		        // If in institution mode, display Lab as the primary label
		        cp.setContent(labLink, null);
		    }
		} else {
		    // If in Central mode, display Institution as primary, lab as secondary.
		    cp.setContent(instLabel, labLink);
		}
		setWidget(row, col++, cp);
	}

    void previousPage() {
        // Move back a page.
        int startIndex = currentResults.getResultSet().getStartIndex() - PAGE_SIZE;
        assert(startIndex >= 0) : "paged beyond the start of the result list";
        executeNewPageSearch(startIndex);
    }

    void nextPage() {
        // Move forward a page.
        int startIndex = currentResults.getResultSet().getStartIndex() + PAGE_SIZE;
        assert(startIndex < currentResults.getResultSet().getTotalCount()) : "paged beyond the end of the result list";
        executeNewPageSearch(startIndex);
    }

    private void executeNewPageSearch(int startIndex) {
        SearchRequest newRequest = new SearchRequest();
        SearchRequest oldRequest = currentResults.getResultSet().getRequest();
        newRequest.setInstitution(oldRequest.getInstitution());
        // Is it risky to not create a new term and binding?
        newRequest.setTerm(oldRequest.getTerm());
        newRequest.setBinding(oldRequest.getBinding());
        newRequest.setStartIndex(startIndex);
        SearchContext.INSTANCE.search(newRequest, true);
    }

}
