/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.eaglei.ui.gwt.security.Session;
import org.eaglei.ui.gwt.security.SessionContext;

public class TopPanel
extends Composite
implements SessionContext.SessionListener {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    Label welcomeLabel;
    @UiField
    Anchor registerAnchor;
    @UiField
    UListElement loginList;
    @UiField
    TextBox userTextBox;
    @UiField
    PasswordTextBox passTextBox;
    @UiField
    Button loginButton;
    boolean signedIn = false;
    public static String[] wfStates;
    public static Map<String, Boolean> accessMap;

    public TopPanel() {
        this.initWidget((Widget)binder.createAndBindUi(this));
        this.passTextBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    TopPanel.this.performLogin();
                }
            }
        });
        this.loginButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TopPanel.this.performLogin();
            }
        });
        this.registerAnchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TopPanel.this.signedIn) {
                    TopPanel.this.performLogout();
                }
            }
        });
        SessionContext.INSTANCE.addListener(this);
    }

    private void performLogin() {
        String user = this.userTextBox.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert((String)"A username is required");
            return;
        }
        String pass = this.passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert((String)"A password is required");
            return;
        }
        SessionContext.INSTANCE.logIn(user.trim(), pass.trim());
    }

    private void performLogout() {
        SessionContext.INSTANCE.logOut();
    }

    @Override
    public void onLogOut() {
        this.welcomeLabel.setText("Please login");
        this.registerAnchor.setText("Register");
        this.loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.signedIn = false;
        this.userTextBox.setText("");
        this.passTextBox.setText("");
    }

    @Override
    public void onLogIn(Session session) {
        this.welcomeLabel.setText("Welcome, " + session.getUserName());
        this.registerAnchor.setText("Logout");
        this.loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.signedIn = true;
    }

    static {
        accessMap = new HashMap<String, Boolean>();
    }

    static interface Binder
    extends UiBinder<Widget, TopPanel> {
    }
}

